/**
 * @author Deepak Mathur
 */
Ext.define('Academia.view.leavemanagement.approvalsetup.LMApprovalSetupFilter', {
    extend: 'Ext.form.Panel',
    alias: 'widget.lmapprovalsetupfilter',
    //autoScroll: true,
    frame: false,
    cls: 'customSearchPanel',
    method: 'POST',
    standardSubmit: false,
    plugins: "formlabelrequired",
    items: [{
        xtype: 'fieldcontainer',
        layout: 'hbox',
        defaults: {
            labelAlign: 'top',
            width: 256
        },
        items: [{
            xtype: 'customcombobox',
            fieldLabel: getPersonModuleTranslation('EMPLOYEE_ID_OR_NAME'),
            name: 'lmFacultyCodeItemId',
            itemId: 'lmFacultyCodeItemId',
            store: 'coursetransaction.sectionmanagement.EmployeeIdValueSmartSearch',
            valueField: 'code',
            displayField: 'valueCode',
            queryParam: 'codeOrName',
            minChars: 3,
            typeAhead: false,
            hideTrigger: true,
            forceSelection: true,
            //allowBlank:false,
            emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
            listConfig: {
                listeners: {
                    beforeshow: function(picker) {
                        picker.minWidth = picker.up('combobox').getSize().width;
                    }
                },
                loadingText: getCommonTranslation('SEARCHING'),
                emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
                getInnerTpl: function() {
                    return '<div class="search-item">' +
                        '{value}' +
                        '</div>';
                }
            }
        }, {
            xtype: 'customcombobox',
            fieldLabel: getCommonTranslation('USER_GROUP_TYPE'),
            name: 'lmUserGroupType',
            itemId: 'lmUserGroupType',
            store: 'userGroup.UserGroupStore',
            valueField: 'id',
            displayField: 'userGroupName',
            //allowBlank: false,
            editable: false,
            queryMode: 'local'
        }, {
            xtype: 'customcombobox',
            fieldLabel: getCommonTranslation('ACADEMY_LOCATION'),
            name: 'lmAcademyLocationCombo',
            itemId: 'lmAcademyLocationCombo',
            editable: false,
            store: 'user.UserAcademyLocationStore',
            displayField: 'value',
            valueField: 'id'
            //            queryMode:'local'		
        }, {
            xtype: 'customcombobox',
            name: 'lmConfigStatus',
            itemId: 'lmConfigStatus',
            store: 'leavemanagement.leaveapprovalsetup.LMConfigurationStatusStore',
            fieldLabel: getPersonModuleTranslation('LMAS_CONFIGURATION_STATUS'),
            valueField: 'Dvalue',
            displayField: 'value',
            //value:'Inward',
            //typeAhead:false,
            //allowBlank:false,
            // forceSelection: true,
            editable: false,
            /*listeners: {
                renderer: function(combo) {
                	var a = combo
                }
            }*/
        }]
    }, {
        xtype: 'fieldset',
        collapsible: true,
        collapsed: true,
        title: getServiceRequestTranslation('MORE_FILTERS'),
        titleCollapse: true,
        defaults: {
            labelAlign: 'top',
        },
        style: {
            marginTop: '33px!important'
        },
        items: [{
            xtype: 'fieldcontainer',
            layout: 'hbox',
            defaults: {
                labelAlign: 'top',
                width: 256
            },
            items: [{
                xtype: 'customcombobox',
                itemId: 'lmDepartment',
                fieldLabel: getPersonModuleTranslation('DEPARTMENT'),
                valueField: 'id',
                displayField: 'name',
                name: 'lmDepartment',
                editable: false,
                triggerAcation: 'all',
                fourceSelection: true,
                store: 'department.ParentDepartmentByAccesibleStore'
                /*listeners: {
                    render: function(combo) {
                        var store = Ext.create('Academia.store.facilitiesresources.resourcebooking.departmentFilterStore');
                        combo.bindStore(store);
                    }
                }*/

            }, {
                xtype: 'customcombobox',
                itemId: 'lmDesignationCombo',
                fieldLabel: getPersonModuleTranslation('DESIGNATION'),
                store: 'common.DesignationTypeStore',
                valueField: 'id',
                displayField: 'value',
                name: 'lmDesignationCombo',
                editable: false,
                triggerAcation: 'all',
                fourceSelection: true,
            }, {
                xtype: 'customcombobox',
                fieldLabel: getCommonTranslation('GENDER'), //Gender
                name: 'lmGender',
                itemId: 'lmGender',
                valueField: 'id',
                displayField: 'value',
                store: 'common.GenderTypeStore',
                //queryMode: 'local',
                editable: false,
            }]
        }, {
            xtype: 'fieldcontainer',
            layout: 'hbox',
            defaults: {
                labelAlign: 'top',
                width: 256
            },
            items: [{
                xtype: 'datefield',
                fieldLabel: getPersonModuleTranslation('DATE_OF_JOIN_FROM'),
                itemId: 'joiningDateFrom',
                name: 'joiningDateFrom',
                listeners: {
                    render: function(field) {
                        return dateFormatRender(field);
                    }
                },
              //--submitFormat: CONSTANTS.SUBMIT_DATE_FORMAT
            }, {
                xtype: 'datefield',
                fieldLabel: getPersonModuleTranslation('DATE_OF_JOIN_TO'),
                itemId: 'joiningDateTo',
                name: 'joiningDateTo',
                listeners: {
                    render: function(field) {
                        return dateFormatRender(field);
                    }
                },
              //--submitFormat: CONSTANTS.SUBMIT_DATE_FORMAT
            },{
                xtype: 'customcombobox',
                name: 'lmApprovalFlow',
                itemId: 'lmApprovalFlow',
                store: 'leavemanagement.leaveapprovalsetup.LMApprovalTypeFlowStore',
                fieldLabel: getPersonModuleTranslation('LMAS_APPROVAL_FLOW_TYPE'),
                valueField: 'value',
                displayField: 'name',
                //value:'Inward',
                typeAhead:false,
                //allowBlank:false,
                forceSelection: true,
                editable: false,
                /*listeners: {
                    renderer: function(combo) {
                    	var a = combo
                    }
                }*/
            }]
        }]
    }, {
        xtype: 'fieldcontainer',
        width: 'auto',
		layout : {
			type : 'hbox'
		},
		cls: 'customSearchPanelBtnsFieldContainerCls',
        items: [{
            xtype: 'button',
            text: getCommonTranslation('SEARCH'),
            itemId: 'searchBtnApprovalSetupfilterItemId',
            buttonAlign: 'left',
            ui: 'CustomBtnSubmit',
            scale: CONSTANTS.BUTTONSIZE,
            formBind: true
        }, {
            xtype: 'button',
            itemId: 'resetBtnApprovalSetupfilterItemId',
            text: getCommonTranslation('RESET'),
            ui: 'CustomBtnCancel',
            scale: CONSTANTS.BUTTONSIZE
        }]
    }]
});