/**
 * @author Soham.Gurjar
 */
Ext.define('Academia.view.lecturerCostingDefinition.LCDAddCostServiceWindow', {
	extend: 'Ext.window.Window',
	alias: 'widget.lcdaddcostservicewindow',
	modal: true,
	autoScroll:true,
	title:getCommonTranslation('COST_DETAILS'),
	closeAction: 'destroy',
	items: [{
		xtype: 'idgeneratorcustomformwin',
		defaults:{
			labelAlign:'top',
			autoScroll:false
		},
		standardSubmit: false,
		plugins:"formlabelrequired",    
		items:[{
			xtype: 'fieldcontainer',
			width:'100%',
			layout: {
				type: 'hbox'
			},
			defaults :{
				width: 256,
				labelAlign:'top'
			},
			items : [{
				xtype : 'datefield',
				anchor : '100%',
				id:'costStart',
				fieldLabel : getCommonTranslation('FROM_DATE'),
				name : 'costStart',
				itemId:'costStart',
				endDateField : 'costend',
				listeners: {
					render: function(field) {
						return dateFormatRender(field);
					}
				},
				vtype : 'daterange',
				allowBlank:false
			},
			{
				xtype : 'datefield',
				anchor : '100%',
				id:'costend',
				fieldLabel : getCommonTranslation('TILL_DATE'),
				name : 'costend',
				itemId : 'costend',
				startDateField : 'costStart',
				listeners: {
					render: function(field) {
						return dateFormatRender(field);
					}
				},
				vtype : 'daterange',
				allowBlank:false
			}]
		},{
			xtype: 'fieldcontainer',
			width:'100%',
			layout: {
				type: 'hbox'
			},
			defaults :{
				width: 256,
				labelAlign:'top'
			},
			items:[{
					xtype: 'customcombobox',
					name: 'currency',
					itemId:'currency',
					fieldLabel: getFeeAndPaymentCommonTranslation('CURRENCY'),
					store: 'feeandpayment.AccountingConfigCurrencyStore',
					valueField: 'id',
					displayField: 'name',
					typeAhead:true,
					forceSelection:true,
					allowBlank: false,
				},{
					xtype:'numberfield',
					fieldLabel: getCommonTranslation('COST'),
					itemId:'costId',
					name: 'cost',
					mouseWheelEnabled :false,
					hideTrigger :true,
					allowDecimals:true,
					allowExponential:false,
					validateOnBlur: true,
					allowBlank: false,
					decimalPrecision: 2,
					minValue: 0,
					maxValue:999999,
					validator: function(value) {
				        if (value === '' || value === null) {
				            return true;
				        }
				        var parts = value.toString().split('.');
				        if (parts.length === 2 && parts[1].length > 2) {
				            return 'Only up to two decimal places are allowed.';
				        }
				        return true;
				    }
				}]
		},{
			xtype: 'fieldcontainer',
			width:'100%',
			layout: {
				type: 'hbox'
			},
			defaults :{
				width: 256,
				labelAlign:'top'
			},
			items:[{
					xtype:'numberfield',
					fieldLabel: getCommonTranslation('MAX_DAILY_HOURS'),
					itemId:'maxDailyHours',
					name: 'maxDailyHours',
					mouseWheelEnabled :false,
					hideTrigger :true,
					allowDecimals:true,
					allowExponential:false,
					validateOnBlur: true,
					allowBlank: true,
					decimalPrecision: 2,
					minValue: 0,
					maxValue:999999,
					validator: function(value) {
				        if (value === '' || value === null) {
				            return true;
				        }
				        var parts = value.toString().split('.');
				        if (parts.length === 2 && parts[1].length > 2) {
				            return 'Only up to two decimal places are allowed.';
				        }
				        return true;
				    }
				}]
		},{
			xtype: 'fieldcontainer',
			 layout: 'fit',
			 defaults: {
				 labelAlign: 'top'
			 },
			 height: 'auto',
			items:[{
				 xtype: 'textarea',
				 name: 'comments',
				 itemId:'comments',
				 fieldLabel: getCommonTranslation('COMMENTS'),
				 width: 536,
				 maxLength:512,
				resizable: false,
				allowBlank: true,	
				 listeners:{
					 resize: function( ta, width, height, oldWidth, oldHeight, eOpts ){
						 try{
							 if(ta.getHeight() > 20){
								 var resizeHandlerDiv = Ext.query("#"+ta.id+"-rzwrap-rzproxy")[0];
								 ta.setHeight(resizeHandlerDiv.offsetHeight - 20);
							 }
						 }
						 catch(e){
							 //--
						 }
					 }
				 }
			 }]
		},{
			xtype: 'fieldcontainer',
			width:'100%',
			cls:'windowBtnPos',
			items: [{
				xtype: 'button',
				action : 'Submit',
				formBind: true,
				text: getCommonTranslation('SAVE'),
				itemId: 'costServiceSubmitBtn',
				ui: 'CustomBtnSubmit',
				scale: CONSTANTS.BUTTONSIZE,
				formBind: true
			}, {
				xtype: 'button',
				text: getCommonTranslation('CANCEL'),
				itemId: 'costServiceCancelBtn',
				ui: 'CustomBtnCancel',
				scale: CONSTANTS.BUTTONSIZE
			}]
		}]
	}]
});
