var lcdServiceGridStore =Ext.create('Academia.store.lecturercostingdefinition.LCDEditServiceStore');
Ext.define('Academia.view.lecturerCostingDefinition.LecturerCostingServiceInnerGrid', {
	extend: 'Academia.view.facilitiesresources.resourcebooking.StaticGridExcelExport',
	alias : 'widget.lecturercostingserviceinnergrid',
	store : lcdServiceGridStore,
	border: true,
	title: getCommonTranslation('LECTURER_COSTING_LIST'),
	isGridConfigurable: true,
	enableColumnHide: false,
	selType:'checkboxmodel',
	height: 300,
	width: '100%',
	
	viewConfig : {
		stripeRows : CONSTANTS.STRIPEROWS,
		listeners: {
	        refresh: function(view) {
	            view.el.dom.style.overflowX = 'hidden';
	        }
	    }
	},
	dockedItems : [{
		xtype : 'toolbar',
		dock : 'bottom',
		items : [{
			xtype: 'custompagingtoolbar',
			itemId : 'custompagingtoolbarId',
			plugins:['pagesize'],
			store : lcdServiceGridStore,
			emptyMsg :getCourseTxCommonTranslation('EMPTY_MESSAGE'),
			displayInfo : true
		} ]
	}],
	initComponent: function() {
		var grid=this;                   
		grid.addExportToolBarItems(grid);
		this.callParent(arguments);
	},
	tbar: [{
		xtype: 'button',
		text: getCommonTranslation('SAVE'),
		itemId: 'editServiceCostingBtn'
	},
	{
		xtype: 'button',
		itemId: 'btnDelete',
		cls: 'CustomToolbarBtnReject',
		tooltip: getCommonTranslation('DELETE'),
		glyph: ICONGLYPH.DELETEGLYPH
	}],
	columns : [{
		header: getCommonTranslation('FROM_DATE'),
		dataIndex: 'fromDate',
		flex: 1,
		editor: {
			xtype: 'datefield',
			format: 'd-m-Y',
			allowBlank: false,
			editable: false,
			// remove or set true if needed
			listeners: {
				select: function (field, value) {
					var grid = field.up('grid');
					var record = grid.getSelectionModel().getSelection()[0];
					var tillDateColumn = null;
					for (var i = 0; i < grid.columns.length; i++) {
					    if (grid.columns[i].dataIndex === 'tillDate') {
					        tillDateColumn = grid.columns[i];
					        break;
					    }
					}
					var tillDateEditor = tillDateColumn.getEditor();

					grid.suspendLayouts();
					record.set('fromDate', value.getTime());
					record.set('tillDate', null);
					tillDateEditor.setMinValue(value);
					grid.resumeLayouts();
				}
			}
		},
		renderer: function (value) {
			if (!value) return '';
			return Ext.Date.format(new Date(value), 'd-m-Y');
		}
	}
	,{
		header: getCommonTranslation('TILL_DATE'),
		dataIndex: 'tillDate',
		flex: 1,
		editor: {
			xtype: 'datefield',
			format: 'd-m-Y',
			allowBlank: false,
			editable: false, // Use true if you want to allow typing
			listeners: {
				// Set min value dynamically when editor is shown
				beforeedit: function (editor, context) {
					var fromDate = context.record.get('fromDate');
					if (fromDate) {
						this.setMinValue(new Date(fromDate)); // Ensure only
						// dates after
						// fromDate are
						// selectable
					}
				},
				select: function (field, value) {
					var grid = field.up('grid');
					var record = grid.getSelectionModel().getSelection()[0];
					record.set('tillDate', value.getTime()); // Store as
					// timestamp
				}
			}
		},
		renderer: function (value) {
			if (!value) return '';
			return Ext.Date.format(new Date(value), 'd-m-Y');
		}
	}
	,{
		header: getFeeAndPaymentCommonTranslation('CURRENCY'),
		dataIndex: 'currencyId',
		flex: 1,
		editor: {
			xtype: 'customcombobox', // Assuming this is a valid custom xtype
			name: 'currencyId',
			itemId: 'currencyId',
			store: Ext.create('Academia.store.feeandpayment.AccountingConfigCurrencyStore', {
				autoLoad: true
			}),
			valueField: 'id',
			displayField: 'name',
			queryMode: 'local',
			forceSelection: true,
			editable: false,
			typeAhead: false,
			hideTrigger: false,
			listeners: {
				change: function (field, newValue, oldValue) {
					var grid = field.up('grid');
					var record = grid.getSelectionModel().getSelection()[0];

					// Defensive check
					if (record) {
					    grid.suspendLayouts();
					    record.set('currencyId', newValue);

					    var displayValue = (typeof field.getDisplayValue === 'function')
					        ? field.getDisplayValue()
					        : field.getRawValue();

					    record.set('currency', displayValue);
					    grid.resumeLayouts();
					}
				}
			}
		},
		renderer: function (value, metaData, record) {
			// If the currency name is available, show it
			return record.get('currency') || value || '';
		}
	}
	,{
		header: getCommonTranslation('COST'),
		dataIndex: 'cost',
		flex: 1,
		editor: {
			xtype: 'numberfield',
			name: 'cost',
			itemId: 'cost',
			mouseWheelEnabled: false,
			hideTrigger: true,
			allowDecimals: true,
			decimalPrecision: 2,
			allowExponential: false,
			validateOnBlur: true,
			minValue: 0,
			maxValue: 999999,
			validator: function (value) {
				if (value === '' || value === null) {
					return true;
				}
				var parts = value.toString().split('.');
				if (parts.length === 2 && parts[1].length > 2) {
					return 'Only up to two decimal places are allowed.';
				}
				return true;
			}
		}
	},
	{
		header: getCommonTranslation('MAX_DAILY_HOURS'),
		dataIndex: 'maxDailyHours',
		flex: 1,
		editor: {
			xtype: 'numberfield',
			name: 'maxDailyHours',
			itemId: 'maxDailyHours',
			mouseWheelEnabled: false,
			hideTrigger: true,
			allowDecimals: true,
			decimalPrecision: 2,
			allowExponential: false,
			validateOnBlur: true,
			minValue: 0,
			maxValue: 999999,
			validator: function (value) {
				if (value === '' || value === null) {
					return true;
				}
				var parts = value.toString().split('.');
				if (parts.length === 2 && parts[1].length > 2) {
					return 'Only up to two decimal places are allowed.';
				}
				return true;
			}
		}
	}
	,{
		header: getCommonTranslation('COMMENTS'),
		dataIndex: 'comments',
		flex: 1,
		editor: {
			xtype: 'textarea',
			name: 'comments',
			itemId: 'comments',
			height: 50,
			maxLength: 512,
			allowBlank: true, // Set to false if you want it required
			enforceMaxLength: true
		},
		renderer: function (value) {
			if (value && value.length > 100) {
				return '<div style="height: 3em; overflow: hidden; text-overflow: ellipsis; white-space: nowrap;" ' +
				'data-qtip="' + Ext.String.htmlEncode(value) + '">' +
				Ext.String.htmlEncode(value.substring(0, 100)) + '...' +
				'</div>';
			}
			return Ext.String.htmlEncode(value);
		}
	}
	,{
		header: getProgramandcourseTranslation('UPDATED_BY'),
		dataIndex: 'updatedBy',
		flex: 1,
		sortable: true,
		editable: false // Optional: explicitly non-editable
	},
	{
		header: getProgramandcourseTranslation('UPDATED_DATE'),
		dataIndex: 'updatedDate',
		flex: 1,
		sortable: true,
		editable: false, // optional
		renderer: function (value) {
			if (!value) return '';
			var date = Ext.isDate(value) ? value : new Date(value);
			return Ext.Date.format(date, 'd/m/Y');
		}
	}	],
	plugins: [
		{
			ptype: 'cellediting',  // or 'rowediting'
			clicksToEdit: 1
		}
		]
});
