/**
 * Reset Password Form
 * @author sumit.meena
 */
Ext.define('Academia.view.login.AdminResetPasswordWindow', {
	extend : 'Ext.window.Window',
	alias : 'widget.adminresetpasswordwindow',
	title:getCommonTranslation('RESET_PASSWORD'),
	modal: true,
	y: 100,
	resizable: false,
    bodyCls: 'resetPwdCls',
	items : [{
		xtype : 'form',
		standardSubmit: false,
	    plugins: "formlabelrequired",
	    defaults:{
			labelAlign: 'top',
			width: 256
		},
	items : [{
		xtype:'hidden',
		name: 'resetPasswordFilterdata',
		ItemId:'resetPasswordFilterdataItemId'
	},{
		xtype:'hidden',
		name: 'isForAll',
		ItemId:'isForAllItemId'
	},{
        xtype:'fieldcontainer',
        width: 'auto',
        layout: 'hbox',
        defaults: {
            width: 260,
            labelAlign: 'top',
        },
        items : [{
            xtype: 'radiogroup',
            itemId: 'passwordTypeItemId',
            items: [{
                boxLabel: getCommonTranslation('COMMON_PASSWORD'),
                name: 'passwordType',
                inputValue: true,
                checked: true
            },{
                boxLabel: getCommonTranslation('RANDOM_PASSWORD'),
                name: 'passwordType',
                style:{'margin-top':'5px !important'},
                itemId:'randomPasswordItemId',
                inputValue: false,
                hidden:true
            }]
        }]
    },
	{
	    xtype : 'textfield',
	    allowBlank: false,
	    inputType : 'password',
	    name: 'resetPassword',
	    itemId: 'resetPassword',
	    invalidCls:Ext.baseCSSPrefix + 'form-invalid',
   	    msgTarget:'under',
   	    enforceMaxLength:true,
	    fieldLabel : getCommonTranslation('NEW_PASSWORD')
	}, {
	    xtype : 'textfield',
	    allowBlank: false,
	    inputType : 'password',
	    name: 'confirmedPassword',
	    itemId : 'confirmedPassword',
	    enforceMaxLength:true,
	    fieldLabel : getCommonTranslation('CONFIRM_PASSWORD'),
	    vtype: 'passwordAndPolicyMatch',
	    initialPassField: 'resetPassword'
	},{
		xtype:'fieldcontainer',
		cls:'passwordPolicyCls',
        items : [{
			xtype : 'fieldset',
			collapsible : true,
			cls:'passwordPolicyCls',
			collapsed : false,
			autoScroll:true,
			height:170,
			title : getCommonTranslation('PASSWORD_POLICY'),
			titleCollapse : true,
			defaults : {
				labelAlign : 'top',
				width : 216
			},
			items : [ {
				xtype : 'dataview',
				itemId : 'passwordPolicyTemplate',
				tpl : new Ext.XTemplate('<tpl></tpl>')
			}, {
				xtype : 'displayfield',
				height : 50
			} ]
		}]
	},{
    	xtype:'fieldcontainer',
    	width:'auto',
        items: [{
				xtype: 'button',
				formBind: true,
				text : getCommonTranslation('SUBMIT'),
				itemId: 'submitBtn',
				ui: 'CustomBtnSubmit',
			//	cls:'submitBtnPassword',
				scale: CONSTANTS.BUTTONSIZE    			
        	},{
				xtype: 'button',				
				text : getCommonTranslation('CANCEL'),
				itemId: 'cancelBtn',
				ui: 'CustomBtnCancel',
			//	cls:'resetBtnPassword',
				scale: CONSTANTS.BUTTONSIZE,
				
        	}]
		}]
    }]
});