Ext.define('Academia.view.login.ChangePasswordWindow', {
    extend: 'Ext.window.Window',
    alias: 'widget.changepasswordwindow',
    modal: true,
    height:600,
    autoScroll:true,
    resizable: false,
    title: getCommonTranslation('CHANGE_PASSWORD'),
    items: [{
        xtype: 'form',
        itemId: 'changePasswordForm',
        standardSubmit: false,
        plugins: "formlabelrequired",
        defaults: {
        	width: 275,
            labelAlign: 'top'
        },
        items: [{
            xtype: 'textfield',
            allowBlank: false,
    	    inputType : 'password',
    	    name: 'currentPassword',
    	    fieldLabel : getCommonTranslation('CURRENT_PASSWORD')
        }, {
        	 xtype : 'textfield',
     	    allowBlank: false,
     	    inputType : 'password',
     	    itemId: 'newPassword',
     	    name: 'newPassword',
     	    invalidCls:Ext.baseCSSPrefix + 'form-invalid',
     	    msgTarget:'under',
     	    fieldLabel : getCommonTranslation('NEW_PASSWORD')
     	}, {
     	    xtype : 'textfield',
     	    allowBlank: false,
     	    inputType : 'password',
     	    name: 'confirmedPassword',
     	    fieldLabel : getCommonTranslation('CONFIRM_PASSWORD'),
     	    vtype: 'passwordAndPolicyMatch',
            initialPassField: 'newPassword' // id of the initial password field
        },{
            xtype: 'fieldcontainer',
            items: [{
				xtype : 'fieldset',
				collapsible : true,
				collapsed : true,
				border:0,
				title : getCommonTranslation('PASSWORD_POLICY'),
				titleCollapse : true,
				defaults : {
					labelAlign : 'top',
					width : 275
				},
				style : {
					marginTop : '40px!important',
				},
				items : [ {
					xtype : 'dataview',
					itemId : 'passwordPolicyTemplate',
					tpl : new Ext.XTemplate('<tpl></tpl>')
				}, {
					xtype : 'displayfield',
					height : 30
				} ]
			}]
        }, {
            xtype: 'fieldcontainer',
            width: '100%',
            
            items: [{
                xtype: 'button',
                itemId: 'btnSavePassword',
                text: getCommonTranslation('SUBMIT'),
                ui: 'CustomBtnSubmit',
                scale: CONSTANTS.BUTTONSIZE,
                formBind: true
            }, {
                xtype: 'button',
                itemId: 'cancelSavePassword',
                text: getCommonTranslation('CANCEL'),
                ui: 'CustomBtnCancel',
                scale: CONSTANTS.BUTTONSIZE
            }]
        }]
    }]

});