/**
 * @author Pankaj Sisodiya
 * 
 */
Ext.define('Academia.view.manageCeremony.ManageCeremonyFilter',{
	extend:'Ext.form.FormPanel',
	alias:'widget.manageCeremonyFilter',
	autoScroll:false,
	frame:false,
	standardSubmit:false,
	cls:'panelNoSpace',
	plugins:"formlabelrequired",
	items:[{
		xtype:'form',
		cls:'customSearchPanel',
		items:[{
			xtype:'fieldcontainer',
			width:'100%',
			defaults:{
				labelAlign:'top'
			},
			items:[{
				xtype: 'multiselectcombofield',
				name: 'academyLocationItemId',
				itemId: 'academyLocationItemId',
				fieldLabel:getCommonTranslation('ACADEMY_LOCATION'),
				width: 490,
				store:'common.AcademyLocationNameSeparated',
				allowBlank : false,
				queryParam: "qry",
				valueField : 'id',
				forceSelection : true,
				displayField : 'value',
				hideTrigger:false,
				typeAhead:true,
				triggerAction: 'all',
				minChars:3,			
				emptyText: getCommonTranslation('ENTER_THREE_CHAR')			
			}]
		},{
			
				xtype:'fieldcontainer',
				width:'100%',
				layout:'hbox',
				defaults:{
					labelAlign:'top',
					width:240
				},
				items:[{
	                xtype: 'customcombobox',
	                name:'ceremonyIdName',
					itemId:'ceremonyIdName',
					store:'manageCeremony.CeremonyIdNameStore',
					fieldLabel: getCommonTranslation('Ceremony_ID_Name'),
	                enableKeyEvents: true,
	    			valueField: 'id',
	    			displayField: 'ceremonyName',
	    			queryParam:'ceremonyNameOrId',
	    			minChars:3,
	    			typeAhead:false,
	    			//hideTrigger:true,
	    			triggerCls: Ext.baseCSSPrefix + 'form-search-trigger',
	    			emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
	    			forceSelection:true,
	    			listConfig: {
	    				listeners: {
	    					beforeshow: function(picker) {
	    						picker.minWidth = picker.up('combobox').getSize().width;
	    					}
	    				},
	    				loadingText: getCommonTranslation('SEARCHING'),
	    				emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
	    				getInnerTpl: function() {
	    					return '<div class="search-item">' +
	    					'{ceremonyName}' +
	    					'</div>';
	    				}
	    			}
				},{
                	xtype: 'datefield',
        			name: 'ceremonyDate',
        			itemId: 'ceremonyDate',
        			fieldLabel: getCommonTranslation('CEREMONY_DATE'),
        			listeners: {
        				render: function(field) {
        					return dateFormatRender(field);
        				}
        			}
        		
				},{
					xtype: 'multiselectcombofield',
					name: 'programGroupId',
					itemId: 'programGroupId',
					fieldLabel:getFeeAndPaymentCommonTranslation('PROGRAM_GROUP'),
					store:'program.ProgramGroupStoreForLocalSerach',
					valueField : 'id',
					forceSelection : true,
					displayField : 'value',
					hideTrigger:false,
					_isStoreLoadCalled:true,
					triggerAction: 'all'
				}]
		},{
			xtype: 'fieldcontainer',
			width: 'auto',
			layout: 'hbox',
			itemId: 'ceremonyWithoutMappingPanel',
			defaults: {
				width: 256,
				labelAlign: 'top'
			},
			items: [
				{

					xtype: 'checkboxfield',
					width: 'auto',
					width: 256,
					itemId: 'ceremonyWithoutMappingId',
					boxLabel: getCommonTranslation('CEREMONY_WITHOUT_MAPPING'),
					name: 'CEREMONY_WITHOUT_MAPPING',
					inputValue: true,
					uncheckedValue: false,
					//checked: false

				}
			]
		},{
			xtype : 'fieldcontainer',
			width : 'auto',
			cls: 'customSearchPanelBtnsFieldContainerCls',
    		layout : {
    			type : 'hbox'
    		},
			items: [{
				xtype: 'button',
				text: getCommonTranslation('SEARCH'),
				itemId: 'searchBtnItemID',
				buttonAlign: 'left',
				ui: 'CustomBtnSubmit',
				scale: CONSTANTS.BUTTONSIZE,
				formBind : true
			},{
				xtype: 'button',
				text: getCommonTranslation('RESET'),
				itemId: 'resetBtnItemId',
				ui: 'CustomBtnCancel',
				scale: CONSTANTS.BUTTONSIZE   
			}]	
		}]
	}]
});