/**
 * @author Rohit Sharma
 */
Ext.define('Academia.view.manageMarksModeration.DownloadMarksModerationForm', {
    extend: 'Ext.form.Panel',
    alias: 'widget.downloadMarksModerationForm',
    plugins: "formlabelrequired",
    frame: false,
    standardSubmit: false,
    items: [{
        xtype: 'fieldcontainer',
        width: '100%',
        layout: 'hbox',
        defaults: {
            labelAlign: 'top',
            width: 256
        },
        items: [{
            xtype: 'customcombobox',
            fieldLabel: getCommonTranslation('ACADEMIC_TERM'),
            name: 'academicTerm',
            itemId: 'academicTermMarkModeration',
            displayField: 'value',
            valueField: 'id',
            allowBlank: false,
            forceSelection: true,
            listeners: {
                render: function (combo) {
                    var store = Ext.create('Academia.store.common.AcademicTermStore');
                    combo.bindStore(store);
                }
            }
        }, {
            xtype: 'customcombobox',
            name: 'evaluationPlanId',
            itemId: 'evaluationPlanIdMarkModeration',
            store: Ext.create('Academia.store.examinationcenters.examresultpublish.BulkExamResultPublishEvalPlanStore'),
            fieldLabel: getExaminationTranslation('EVALUATION_PLAN'),
            valueField: 'id',
            displayField: 'value',
            queryParam: 'qry',
            minChars: 3,
            enableKeyEvents: 'true',
            allowBlank: false,
            disabled: true,
            forceSelection: true,
            emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
            listConfig: {
                listeners: {
                    beforeshow: function (picker) {
                        picker.minWidth = picker.up('combobox').getSize().width;
                        picker.maxWidth = picker.up('combobox').getSize().width;
                    }
                },
                loadingText: getCommonTranslation('SEARCHING'),
                emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
                getInnerTpl: function () {
                    return '<div class="search-item">' +
                        '{value}' +
                        '</div>';
                }
            }
        }]
    }, {
        xtype: 'fieldcontainer',
        width: '100%',
        layout: 'hbox',
        defaults: {
            labelAlign: 'top',
            width: 256
        },
        items: [{
            xtype: 'multiselectcombofield',
            name: 'courseId',
            itemId: 'courseItemIdMarkModeration',
            store: Ext.create('Academia.store.examinationcenters.assessmentEvent.ManageAssessmentCoursesStore'),
            fieldLabel: getCommonTranslation('COURSE_CODE_NAME'),
            cls: 'resetPasswordMultiselect',
            valueField: 'id',
            displayField: 'value',
            disabled: true,
            enableKeyEvents: 'true',
            forceSelection: true,
            autoloadStore: false,
            allowBlank: false,
            maxLength: 500000,
            listConfig: {
                loadingText: getCommonTranslation('SEARCHING'),
                emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
                getInnerTpl: function () {
                    return '<div class="search-item">' +
                        '{value}' +
                        '</div>';
                },
                listeners: {
                    beforeshow: function (picker) {
                        picker.minWidth = picker.up('combobox').getSize().width;
                        picker.maxWidth = picker.up('combobox').getSize().width;
                    }
                }
            }
        }, {
            xtype: 'multiselectcombofield',
            name: 'courseVariant',
            itemId: 'courseVariantItemIdMarkModeration',
            store: 'manageMarksModeration.MarksModerationCourseVariantStore',
            fieldLabel: getExaminationTranslation('COURSE_VARIANT'),
            displayField: 'code',
            valueField: 'id',
            autoloadStore: false,
            enableKeyEvents: 'true',
            forceSelection: true,
            disabled: true,
            cls: 'placementProgramMultiselect resetPasswordMultiselect',
            maxLength: 500000,
            listConfig: {
                listeners: {
                    beforeshow: function (picker) {
                        picker.minWidth = picker.up('combobox').getSize().width;
                        picker.width = 'auto';
                        setTimeout(function () {
                            picker.el.dom.style.width = 'auto';
                            picker.el.dom.style.minWidth = picker.up('combobox').getSize().width + 'px';
                        }, 10);
                    }
                },
                loadingText: getCommonTranslation('SEARCHING'),
                emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
                getInnerTpl: function () {
                    return '<div class="search-item">' +
                        '{code}' +
                        '</div>';
                }
            }
        }, {
            xtype: 'groupingcombobox',
            name: 'evaluationLevelName',
            itemId: 'evaluationLevelNameIdMarkModeration',
            groupField: 'code',
            groupDisplayField: 'code',
            store: 'manageMarksModeration.ManageMarksModerationEvalSchemeLevelStore',
            fieldLabel: getExaminationTranslation('EVALUATION_PLAN_LEVEL'),
            displayField: 'value',
            disabled: true,
            allowBlank: false,
            forceSelection: true
        }]
    }, {
        xtype: 'fieldcontainer',
        width: '100%',
        layout: 'hbox',
        defaults: {
            labelAlign: 'top',
            width: 256
        },
        items: [{
            xtype: 'customcombobox',
            name: 'programId',
            itemId: 'programItemIdMarkModeration',
            store: 'manageMarksModeration.MarksModerationProgramStore',
            fieldLabel: getCommonTranslation('PROGRAM_CODE_OR_NAME'),
            valueField: 'id',
            displayField: 'displayValue',
            queryParam: 'name',
            minChars: 3,
            disabled: true,
            enableKeyEvents: 'true',
            forceSelection: true,
            emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
            listConfig: {
            	cls: 'combo-word-break-all',
                loadingText: getCommonTranslation('SEARCHING'),
                emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
                getInnerTpl: function () {
                    return '<div class="search-item">' +
                        '{value}' +
                        '</div>';
                },
                listeners: {
                    beforeshow: function (picker) {
                        picker.minWidth = picker.up('combobox').getSize().width;
                        picker.maxWidth = picker.up('combobox').getSize().width;
                    }
                }
            }
        }, {
            xtype: 'customcombobox',
            name: 'batchId',
            itemId: 'batchItemIdMarkModeration',
            store: Ext.create('Academia.store.examinationcenters.assessmentEvent.ManageAssessmentBatcheStore'),
            fieldLabel: getExaminationTranslation('BATCH'),
            valueField: 'id',
            displayField: 'value',
            disabled: true,
            enableKeyEvents: 'true',
            forceSelection: true,
            listConfig: {
                loadingText: getCommonTranslation('SEARCHING'),
                emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
                getInnerTpl: function () {
                    return '<div class="search-item">' +
                        '{value}' +
                        '</div>';
                },
                listeners: {
                    beforeshow: function (picker) {
                        picker.minWidth = picker.up('combobox').getSize().width;
                        picker.maxWidth = picker.up('combobox').getSize().width;
                    }
                }
            }
        }, {
            xtype: 'customcombobox',
            name: 'periodId',
            itemId: 'periodItemIdMarkModeration',
            disabled: true,
            store: Ext.create('Academia.store.examinationcenters.evaluation.evaluationPlanHeirarchy.MapUnmapPeriodForDynamic'),
            fieldLabel: getExaminationTranslation('PERIOD'),
            valueField: 'id',
            displayField: 'value',
            queryParam: 'name',
            enableKeyEvents: 'true',
            forceSelection: true,
            listConfig: {
                loadingText: getCommonTranslation('SEARCHING'),
                emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
                getInnerTpl: function () {
                    return '<div class="search-item">' +
                        '{value}' +
                        '</div>';
                },
                listeners: {
                    beforeshow: function (picker) {
                        picker.minWidth = picker.up('combobox').getSize().width;
                        picker.maxWidth = picker.up('combobox').getSize().width;
                    }
                }
            }
        }]
    }, {
        xtype: 'fieldcontainer',
        width: '100%',
		cls: 'customSearchPanelBtnsFieldContainerCls',
		layout: 'hbox',
        items: [{
            xtype: 'button',
            itemId: 'markModerationDownload',
            text: getExaminationTranslation('MARK_ENTRY_DOWNLOAD'),
            ui: 'CustomBtnSubmit',
            formBind: true
        }, {
            xtype: 'button',
            text: getCommonTranslation('RESET'),
            itemId: 'resetBtn',
            ui: 'CustomBtnCancel'
        }]
    }]
});