/**
 * @author Rohit Sharma
 */
Ext.define('Academia.view.manageMarksModeration.ProgramLevelMarksModerationFilter', {
    extend: 'Ext.form.Panel',
    alias: 'widget.programLevelMarksModerationFilter',
    plugins: "formlabelrequired",
    autoScroll: false,
    frame: false,
    cls: 'customSearchPanel',
    standardSubmit: false,
    defaults: {
        labelAlign: 'top',
        width: 256
    },
    items: [{
        xtype: 'fieldcontainer',
        width: '100%',
        layout: 'hbox',
        defaults: {
            width: 256,
            labelAlign: 'top'
        },
        items: [{
            xtype: 'customcombobox',
            fieldLabel: getCommonTranslation('ACADEMIC_TERM'),
            name: 'academicTerm',
            itemId: 'academicTermProgLvlMarkModeration',
            displayField: 'value',
            valueField: 'id',
            allowBlank: false,
            forceSelection: true,
            listeners: {
                render: function (combo) {
                    var store = Ext.create('Academia.store.common.AcademicTermStoreForIntakeYearId');
                    combo.bindStore(store);
                }
            }
        }, {
            xtype: 'customcombobox',
            name: 'programId',
            itemId: 'programProgLvlItemId',
            store: Ext.create('Academia.store.manageMarksModeration.ProgramLevelModerationProgramStore'),
            fieldLabel: getCommonTranslation('PROGRAM_CODE_OR_NAME'),
            valueField: 'id',
            displayField: 'display',
            queryParam: 'name',
            minChars: 3,
            width: 256,
            typeAhead: false,
            triggerCls: Ext.baseCSSPrefix + 'x-form-trigger',
            enableKeyEvents: 'true',
            hideTrigger: false,
            forceSelection: true,
            disabled: true,
            allowBlank: false,
            emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
            listConfig: {
                listeners: {
                    beforeshow: function (picker) {
                        picker.minWidth = picker.up('combobox').getSize().width;
                        picker.maxWidth = picker.up('combobox').getSize().width;
                    }
                },
                loadingText: getCommonTranslation('SEARCHING'),
                emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
                getInnerTpl: function () {
                    return '<div class="search-item">' +
                        '{display}' +
                        '</div>';
                }
            }
        }, {
            xtype: 'customcombobox',
            name: 'batchId',
            itemId: 'batchProgLvlItemId',
            store: Ext.create('Academia.store.manageMarksModeration.ProgramLevelModerationBatchStore'),
            fieldLabel: getExaminationTranslation('BATCH'),
            valueField: 'id',
            displayField: 'value',
            queryParam: 'batchName',
            minChars: 3,
            width: 256,
            disabled: true,
            forceSelection: true,
            typeAhead: false,
            disabled: true,
            listConfig: {
                listeners: {
                    beforeshow: function (picker) {
                        picker.minWidth = picker.up('combobox').getSize().width;
                        picker.maxWidth = picker.up('combobox').getSize().width;
                    }
                }
            }
        }]
    }, {
        xtype: 'fieldcontainer',
        width: 'auto',
        layout: 'hbox',
        defaults: {
            width: 256,
            labelAlign: 'top'
        },
        items: [{
            xtype: 'customcombobox',
            name: 'periodId',
            itemId: 'periodProgLvlItemId',
            store: Ext.create('Academia.store.manageMarksModeration.ProgramLevelModerationPeriodStore'),
            fieldLabel: getExaminationTranslation('PERIOD'),
            valueField: 'id',
            displayField: 'value',
            disabled: true,
            queryParam: 'qry',
            minChars: 3,
            width: 256,
            forceSelection: true,
            typeAhead: true,
            disabled: true,
            listConfig: {
                listeners: {
                    beforeshow: function (picker) {
                        picker.minWidth = picker.up('combobox').getSize().width;
                        picker.maxWidth = picker.up('combobox').getSize().width;
                    }
                },
            }
        }, {
            xtype: 'customcombobox',
            name: 'evaluationplan',
            itemId: 'evalautionPlanProgLvlId',
            store: Ext.create('Academia.store.manageMarksModeration.ProgramLevelModerationPlanStore'),
            fieldLabel: getExaminationTranslation('EVALUATION_PLAN'),
            valueField: 'id',
            width: 256,
            displayField: 'value',
            queryParam: 'evaluationPlanNumber',
            minChars: 3,
            typeAhead: false,
            triggerCls: Ext.baseCSSPrefix + 'x-form-trigger',
            enableKeyEvents: 'true',
            hideTrigger: false,
            forceSelection: true,
            disabled: true,
            allowBlank: false,
            emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
            listConfig: {
                listeners: {
                    beforeshow: function (picker) {
                        picker.minWidth = picker.up('combobox').getSize().width;
                        picker.maxWidth = picker.up('combobox').getSize().width;
                    }
                },
                loadingText: getCommonTranslation('SEARCHING'),
                emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
                getInnerTpl: function () {
                    return '<div class="search-item">' +
                        '{value}' +
                        '</div>';
                }
            }
        }, {
            xtype: 'multiselectcombofield',
            name: 'courseId',
            itemId: 'courseProgLvlItemId',
            store: Ext.create('Academia.store.manageMarksModeration.ProgramLevelModerationCourseStore'),
            fieldLabel: getCommonTranslation('COURSE_CODE_NAME'),
            valueField: 'id',
            displayField: 'codeValue',
            queryParam: 'name',
            autoloadStore: false,
            typeAhead: false,
            triggerCls: Ext.baseCSSPrefix + 'x-form-trigger',
            enableKeyEvents: 'true',
            hideTrigger: false,
            forceSelection: true,
            disabled: true,
            cls: 'placementProgramMultiselect',
            listConfig: {
                listeners: {
                    beforeshow: function (picker) {
                        picker.minWidth = picker.up('combobox').getSize().width;
                        picker.maxWidth = picker.up('combobox').getSize().width;
                    }
                },
                loadingText: getCommonTranslation('SEARCHING'),
                emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
                getInnerTpl: function () {
                    return '<div class="search-item">' +
                        '{codeValue}' +
                        '</div>';
                }
            }
        }]
    }, {
        xtype: 'fieldcontainer',
        width: 'auto',
        layout: 'hbox',
        defaults: {
            width: 256,
            labelAlign: 'top'
        },
        items: [{
            xtype: 'multiselectcombofield',
            name: 'courseVariant',
            itemId: 'courseVariantProgLvlItemId',
            store: Ext.create('Academia.store.manageMarksModeration.ProgramLevelModerationVariantStore'),
            fieldLabel: getExaminationTranslation('COURSE_VARIANT'),
            displayField: 'value',
            valueField: 'id',
            minChars: 3,
            autoloadStore: false,
            typeAhead: true,
            triggerCls: Ext.baseCSSPrefix + 'x-form-trigger',
            enableKeyEvents: 'true',
            hideTrigger: false,
            forceSelection: true,
            disabled: true,
            cls: 'placementProgramMultiselect',
            listConfig: {
                listeners: {
                    beforeshow: function (picker) {
                        picker.minWidth = picker.up('combobox').getSize().width;
                        picker.width = 'auto';
                        picker.maxWidth = picker.up('combobox').getSize().width;
                        setTimeout(function () {
                            picker.el.dom.style.width = 'auto';
                            picker.el.dom.style.minWidth = picker.up('combobox').getSize().width + 'px';
                        }, 10);
                    }
                },
                loadingText: getCommonTranslation('SEARCHING'),
                emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
                getInnerTpl: function () {
                    return '<div class="search-item">' +
                        '{value}' +
                        '</div>';
                }
            }
        }, {
            xtype: 'groupingcombobox',
            name: 'evaluationLevelName',
            itemId: 'evaluationLevelNameProgLvlId',
            labelAlign: 'top',
            groupField: 'code',
            groupDisplayField: 'code',
            store: Ext.create('Academia.store.manageMarksModeration.ManageMarksModerationEvalSchemeLevelStore'),
            fieldLabel: getExaminationTranslation('EVALUATION_PLAN_LEVEL'),
            displayField: 'value',
            disabled: true,
            allowBlank: false,
            forceSelection: true
        }]
    }, {
        xtype: 'fieldcontainer',
        width: 'auto',
        layout: 'hbox',
        defaults: {
            width: 256,
            labelAlign: 'top'
        },
        items: [{
            xtype: 'customcombobox',
            name: 'admissionCodeSTDName',
            itemId: 'admissionCodeSTDNameProgLvl',
            store: Ext.create('Academia.store.manageMarksModeration.ProgramLevelModerationStudentStore'),
            valueField: 'id',
            displayField: 'studentDisplayValue',
            width: 536,
            forceSelection: true,
            enableKeyEvents: 'true',
            typeAhead: false,
            fieldLabel: getExaminationTranslation('ADMISSION_CODE_STD_NAME_STD_CODE'),
            minChars: 3,
            emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
            triggerCls: Ext.baseCSSPrefix + 'x-form-trigger',
            hideTrigger: false,
            queryParam: 'studentName',
            disabled: true,
            listConfig: {
                listeners: {
                    beforeshow: function (picker) {
                        picker.minWidth = picker.up('combobox').getSize().width;
                        picker.maxWidth = picker.up('combobox').getSize().width;
                    }
                },
                loadingText: getCommonTranslation('SEARCHING'),
                emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
                getInnerTpl: function () {
                    return '<div class="search-item">' +
                        '{value}' +
                        '</div>';
                }
            }
        }]
    }, {
        xtype: 'fieldcontainer',
        width: '100%',
        layout: 'hbox',
		cls: 'customSearchPanelBtnsFieldContainerCls',
        items: [{
            xtype: 'button',
            text: getCommonTranslation('SEARCH'),
            itemId: 'searchBtn',
            //buttonAlign: 'left',
            ui: 'CustomBtnSubmit',
            scale: CONSTANTS.BUTTONSIZE,
            formBind: true
        }, {
            xtype: 'button',
            text: getCommonTranslation('RESET'),
            itemId: 'resetBtn',
            ui: 'CustomBtnCancel',
            scale: CONSTANTS.BUTTONSIZE
        }]
    }]
});