
Ext.define('Academia.view.managetarget.EnquiryLeadDetailsManageTargetGrid', {
    extend: 'Academia.view.facilitiesresources.resourcebooking.StaticGridExcelExport',
    alias: 'widget.enquiryleaddetailsmanagetargetgrid',
    store: '',
    title: getAdmissionTranslation('ENQUIRY_LEAD_DETAILS'),
    border: true,
    autoScroll: false,
    frame: false,
    viewConfig: {
        stripeRows: CONSTANTS.STRIPEROWS
    },
    initComponent: function() {
        var grid = this;
        grid.addExportToolBarItems(grid, false);
        this.callParent(arguments);
    },
    columns: [{
        header: getAdmissionTranslation('SALES_STAFF'),
        dataIndex: 'salesStaff',
        flex: 1,
        sortable: true
    },/*{
        header: getAdmissionTranslation('PRESENTATION_NAME'),
        dataIndex: 'presentationName',
        flex: 1,
        sortable: true,
    }*/, {
        header: getAdmissionTranslation('TOTAL_ENQUIRY_TARGET'),
        dataIndex: 'actualTarget',
        flex: 1,
        sortable: true,
        editor: {
            xtype: 'numberfield',
            name: 'actualTarget',
            itemId: 'actualTargetItemId',
            maxLength: 5,
            enforceMaxLength: true,
            hideTrigger: true,
            keyNavEnabled: false,
            mouseWheelEnabled: false,
            allowExponential: false,
            allowDecimals: false
        },
        renderer: function(val, rec) {
            if (isNullOrEmpty(val)) {
                rec.tdCls = 'gridInputCustomStyle';
                return getExaminationTranslation('CLICK_TO_ENTER');
            } else {
                return val;
            }
        }
    }, {
        header: getAdmissionTranslation('TOTAL_ACTUAL_ENQUIRIES'),
        dataIndex: 'actualTargetAchived',
        flex: 1,
        sortable: true,
    }, {
        header: getAdmissionTranslation('PERCENTAGE_TO_ENQUIRY_TARGET'),
        dataIndex: 'percentageTargetAchieved',
        flex: 1,
        sortable: true
    }, {
        header: getEnquiryTranslation('TOTAL_VARIANCE'),
        dataIndex: 'targetVariance',
        flex: 1,
        sortable: true
    }],
    plugins: [{
        ptype: 'cellediting',
        clicksToEdit: 1,
        listeners: {
            beforeedit: function(obj, editor, context) {
                return true;
            }
        }
    }]
});

var cellEditing = Ext.create('Ext.grid.plugin.CellEditing', {
    clicksToEdit: 1,
    listeners: {
        beforeedit: function(editor, context, e) {}
    }
});