/**
 * @author Amit G
 */
Ext.define('Academia.view.managetarget.ManageTargetAcademyLocationWiseGrid', {
    extend: 'Academia.view.facilitiesresources.resourcebooking.StaticGridExcelExport',
    alias: 'widget.managetargetacademylocationwisegrid',
    store: 'managetarget.ManageTargetStore',
    title: getCommonTranslation('VIEW_TARGETS_BY_ACADEMY_LOCATION'),
    border: true,
    autoScroll: false,
    frame: false,
    viewConfig: {
        stripeRows: CONSTANTS.STRIPEROWS
    },
	 features: [{
	        ftype: 'summary',
	        showSummaryRow:CONSTANTS.SHOW_SUMMARY_ROW 
	    }],
    initComponent: function() {
        var grid = this;
        grid.addExportToolBarItems(grid, false);
        this.callParent(arguments);
    },
    tbar: [{
        
            xtype: 'button',
            itemId: 'saveBtnManageTargetGridALWiseItemId',
            tooltip: getCommonTranslation('SAVE'),
            text: getCommonTranslation('SAVE'),
           scale: CONSTANTS.BUTTONSIZE
    },{
		xtype : 'button',
		itemId : 'exportReportItemId',
		tooltip : getCommonTranslation('EXPORTREPORTS'),
		text : getCommonTranslation('EXPORTREPORTS'),
		formBind:true
	}],
    columns: [{
        header: getCommonTranslation('ACADEMY_LOCATION'),
        dataIndex: 'academyLocationPrintName',
        flex: 1,
        sortable: true,
		summaryRenderer: function(value, summaryData, dataIndex) {
	          return getFeeAndPaymentCommonTranslation('GRAND_TOTAL');
	      }
    }, {
        header: getCommonTranslation('INTAKE_YEAR'),
        dataIndex: 'intakeYearValue',
        flex: 1,
        sortable: true,
    }, {
    	header: getEnquiryTranslation('MT_MANAGING_DIRECTOR'),
        dataIndex: 'managingDirectorName',
        flex: 1,
        sortable: true,
        //summaryType: 'sum',
        editor: {
        	xtype: 'customcombobox',
           // name: 'managingDirector',
            itemId: 'managingDirectorItemId',
            //store: 'personinfo.common.disciplinaryactivity.ReportedUserSearchCombos',
            allowBlank: true,
          //  queryParam:'codeOrName',
         //   triggerAction: 'all',
            forceSelection: true,
          //  emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
            enableKeyEvents  : 'true',
          //  triggerCls : Ext.baseCSSPrefix + 'form-search-trigger',
			//minChars:3,
			displayField: 'value',
			valueField: 'value',
		//	queryMode: 'remote',
			listeners: {
                select: function(obj, record){
                	var grid = obj.up('grid')
                	var selectedRecord = grid.getSelectionModel().getSelection()[0];
                	
                	var recordToBeUpdated = grid.getStore().findRecord('serialNo',selectedRecord.data.serialNo);
                	recordToBeUpdated.set('managingDirectorId',record[0].data.id);
                }
            }
        },
        renderer: function(val, rec) {
            if (isNullOrEmpty(val)) {
                rec.tdCls = 'gridInputCustomStyle';
                return getExaminationTranslation('CLICK_TO_ENTER');
            } else {
            	//rec.tdCls = 'gridInputCustomStyle';
                return val;
            }
        }
    }, {
        header: getEnquiryTranslation('MT_ENQUIRY_TARGET'),
        dataIndex: 'enquiryTarget',
        summaryType: 'sum',
        flex: 1,
        sortable: true
    }, {
        header: getEnquiryTranslation('MT_APPLICATION_TARGET'),
        dataIndex: 'applicationTarget',
        summaryType: 'sum',
        flex: 1,
        sortable: true
    }, {
        header: getEnquiryTranslation('MT_ENROLMENT_PREVIOUS_YEAR'),
        dataIndex: 'enrolmentPreviousYear',
        summaryType: 'sum',
        flex: 1,
        sortable: true
    }, {
        header: getEnquiryTranslation('MT_RETURNING_STUDENTS'),
        dataIndex: 'returningStudents',
        summaryType: 'sum',
        flex: 1,
        sortable: true
    }, {
        header: getEnquiryTranslation('MT_ENROLMENT_BUDGET'),
        dataIndex: 'enrolmentBudget',
        summaryType: 'sum',
        flex: 1,
        sortable: true
    }, {
        header: getEnquiryTranslation('MT_REVISED_BUDGET'),
        dataIndex: 'revisedBudget',
        summaryType: 'sum',
        flex: 1,
        sortable: true
    }, {
        header: getEnquiryTranslation('MT_ENROLMENT_TARGET'),
        dataIndex: 'enrolmentTarget',
        summaryType: 'sum',
        flex: 1,
        sortable: true
    },{
        header: getEnquiryTranslation('MT_BUILDING_CAPACITY'),
        dataIndex: 'buildingCapacity',
        flex: 1,
        sortable: true
    },{
        header: getEnquiryTranslation('MT_BUILDING_CAPACITY_SPECIALIST'),
        dataIndex: 'buildingCapacitySpecialist',
        flex: 1,
        sortable: true
    }],
    plugins: [{
        ptype: 'cellediting',
        clicksToEdit: 1,
        listeners: {
            beforeedit: function(obj, editor, context) {
            	if(editor.field == "managingDirectorName"){
            		var grid = editor.grid;
                	var selectedRecord = grid.getSelectionModel().getSelection()[0];
                    var academyLocationId = selectedRecord.data.academyLocationId;
                   
                    var combo = editor.column.field;
                    combo.reset();
                    var store = Ext.create('Academia.store.managetarget.UserForManageTarget');
                    combo.bindStore(store);
                    
                    var store = combo.getStore();
                    store.getProxy().extraParams = {
                    	academyLocationId:academyLocationId
                    };
                    store.load();
            	}
            	return true;
            }
        }
    }]
});

var cellEditing = Ext.create('Ext.grid.plugin.CellEditing', {
    clicksToEdit: 1,
    listeners: {
        beforeedit: function(editor, context, e) {}
    }
});
