/**
 * @author Rohit Thadani
 */
Ext.define('Academia.view.managetarget.ManageTargetByQualificationsGrid', {
    extend: 'Academia.view.facilitiesresources.resourcebooking.StaticGridExcelExport',
    alias: 'widget.managetargetbyqualificationsgrid',
    store: 'managetarget.ManageTargetByQualificationGridStore',
    title: getAdmissionTranslation('PROGRAM_TARGETS'),
    border: true,
    autoScroll: false,
    frame: false,
    viewConfig: {
        stripeRows: CONSTANTS.STRIPEROWS
    },
    headerFix:{
        headerFix: true,
        portalIdsWithStructure: {
            'managetargetbystafftabstructure':1
        }
    },
    initComponent: function() {
        var grid = this;
        grid.addExportToolBarItems(grid, false);
        this.callParent(arguments);
    },
    columns: [{
        header: getCommonTranslation('ACADEMY'),
        dataIndex: 'academyName',
        flex: 1,
        sortable: true
    },{
        header: getCommonTranslation('LOCATION'),
        dataIndex: 'locationName',
        flex: 1,
        sortable: true
    },{
        header: getCommonTranslation('INTAKE_YEAR'),
        dataIndex: 'intakeYearName',
        flex: 1,
        sortable: true,
    },{
		header:  getCommonTranslation('MODE_OF_DELIVERY'),
		dataIndex: 'modeOfDeliveryValue',
		flex:1,
		sortable:true
	},{
		header:  getCommonTranslation('REGISTRATION_TYPE'),
		dataIndex: 'registrationType',
		flex:1,
		sortable:true,
		renderer:function(value,meta,record){
			if(!isNullOrEmpty(value)){
				if(value==true){
					return getCommonTranslation("PART_TIME");	
				}else {
					return getCommonTranslation("FULL_TIME");	
				}
				
			}
		}
	}, {
        header: getAdmissionTranslation('PROGRAM_REGISTRATION_TARGET'),
        dataIndex: 'actualRegistrationTarget',
        flex: 1,
        sortable: true
    }, {
        header: getAdmissionTranslation('PROGRAM_REGISTRATION_ACTUAL'),
        dataIndex: 'actualRegistrationTargetAchived',
        flex: 1,
        sortable: true
    }, {
        header: getAdmissionTranslation('PERCENTAGE_TO_PROGRAM_REGISTRATION_TARGET'),
        dataIndex: 'percentageRegistrationTarget',
        flex: 1,
        sortable: true,
        renderer : function(value){
        	if(!isNullOrEmpty(value)){
        		if(value == 0 || value == 0.00){
        			return  '0.00 %';
        		}else{
        			return  value +' %';
        		}
        		
        	} 
		}
    }, {
        header: getAdmissionTranslation('PROGRAM_REGISTRATION_VARIANCE'),
        dataIndex: 'registrationTargetVariance',
        flex: 1,
        sortable: true
    }, {
        header: getAdmissionTranslation('PROGRAM_APPLICATION_TARGET'),
        dataIndex: 'actualApplicationTarget',
        flex: 1,
        sortable: true
    }, {
        header: getAdmissionTranslation('PROGRAM_APPLICATION_ACTUAL'),
        dataIndex: 'actualApplicationTargetAchived',
        flex: 1,
        sortable: true
    }, {
        header: getAdmissionTranslation('PERCENTAGE_TO_PROGRAM_APPLICATION_TARGET'),
        dataIndex: 'percentageApplicationTarget',
        flex: 1,
        sortable: true,
        renderer : function(value){
        	if(!isNullOrEmpty(value)){
        		if(value == 0 || value == 0.00){
        			return  '0.00 %';
        		}else{
        			return  value +' %';
        		}
        		
        	} 
		}
    }, {
        header: getAdmissionTranslation('PROGRAM_APPLICATION_VARIANCE'),
        dataIndex: 'applicationTargetVariance',
        flex: 1,
        sortable: true
    },  {
        header: getAdmissionTranslation('PROGRAM_ENQUIRY_TARGET'),
        dataIndex: 'actualEnquiryTarget',
        flex: 1,
        sortable: true
    }, {
        header: getAdmissionTranslation('PROGRAM_ENQUIRY_ACTUAL'),
        dataIndex: 'actualEnquiryTargetAchived',
        flex: 1,
        sortable: true
    }, {
        header: getAdmissionTranslation('PERCENTAGE_TO_PROGRAM_ENQUIRY_TARGET'),
        dataIndex: 'percentageEnquiryTarget',
        flex: 1,
        sortable: true,
        renderer : function(value){
        	if(!isNullOrEmpty(value)){
        		if(value == 0 || value == 0.00){
        			return  '0.00 %';
        		}else{
        			return  value +' %';
        		}
        		
        	} 
		}
    }, {
        header: getAdmissionTranslation('PROGRAM_LEAD_VARIANCE'),
        dataIndex: 'enquiryTargetVariance',
        flex: 1,
        sortable: true
    }, {
        header: getAdmissionTranslation('QUALIFICATION_TARGET_DETAILS'),
        dataIndex: 'programCount',
        flex: 1,
        sortable: true,
        renderer : function(value){
           	if( !isNullOrEmpty(value) && value != 0 ){
           	return  '<a href="#">'+value+'</a>';
           	} else {
           	return  '<a href="#">'+"Add"+'</a>';
           	}
    }
    }]
});
