/**
 * @author Amit G 
 * 
 */
Ext.define('Academia.view.managetarget.ManageTargetByStaffFilter', {
    //extend: 'Ext.form.Panel',
	extend:'Academia.view.common.IdGeneratorCustomForm',
    alias: 'widget.managetargetbystafffilter',
	plugins : "formlabelrequired",
	frame: false,
	method : 'POST',
	standardSubmit : false,
	cls:'customSearchPanel',
    items: [{
            xtype: 'fieldcontainer',
            layout: 'hbox',
            defaults: {
                labelAlign: 'top',
                width: 256
            },
            items: [{
			xtype: 'multiselectcombofield',
			width: 960,
			height:58,
			name: 'multiselectTargetByStaffAcademy',
			itemId: 'multiselectTargetByStaffAcademyId',
			allowBlank : false,
			fieldLabel : getCommonTranslation('ACADEMY_LOCATION'),
			displayField:'value',
			valueField:'id',
			matchFieldWidth:true,
			maxLength:15000,
			autoloadStore: false,
			queryMode:'local',
			listConfig: {
				listeners: {
					beforeshow: function(picker) {
						picker.width = picker.up('combobox').getSize().width;
					}
				},
				loadingText: getCommonTranslation('SEARCHING'),
				emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
				getInnerTpl: function() {
					return '<div class="search-item">' +
					'{code}' +
					'</div>';
				}
			},
        	listeners  :{
        		render : function(combo){
        			var store=Ext.create('Academia.store.user.UserAcademyLocationStore');
        			combo.bindStore(store)
        		}
        	}
        }]
    },{
        xtype: 'fieldcontainer',
        layout: 'hbox',
        defaults: {
            labelAlign: 'top',
            width: 256
        },
        items: [ {
                xtype: 'customcombobox',
                name: ' viewTargetByStaff',
                itemId: 'viewTargetByStaff',
                fieldLabel: getAdmissionTranslation('STAFF_VIEW_TARGETS_BY'),
                store: Ext.create('Academia.store.managetarget.ManageTargetViewTargetByStaffStore'),
                valueField: 'id',
                displayField: 'value',
                allowBlank: false,
                editable: false,
            },{
                xtype: 'customcombobox',
                name: 'intakeYearStaffId',
                itemId: 'intakeYearStaffItemId',
                fieldLabel: getCommonTranslation('INTAKE_YEAR'),
                store: Ext.create('Academia.store.common.IntakeYearStore'),
                valueField: 'id',
                displayField: 'value',
                allowBlank: false,
                forceSelection: true,
                editable: false,
            },{
				xtype: 'customcombobox',
				name: 'MODE_OF_DELIVERY_ID',
				itemId: 'modeDeliveryId',
				fieldLabel: getCommonTranslation('MODE_OF_DELIVERY'),
				store:'common.ModeOfDeliveryStore',
				valueField: 'id',
				displayField: 'value',
				forceSelection: true
			},
			{
				xtype: 'customcombobox',
				name: 'REGISTRATION_TYPE',
				itemId: 'registrationTypeId',
				fieldLabel: getCommonTranslation('REGISTRATION_TYPE'),
				store:'campaignnew.RegistrationTypeStore',
				valueField: 'id',
				displayField: 'value',
				forceSelection: true
			}, {
	    		xtype: 'multiselectcombofield',
	    		name: 'programGroup',
	    		itemId:'ProgramGroupId',
	    		fieldLabel: getCommonTranslation('PROGRAM_GROUP'),
	    		store:'program.ProgramGroupStoreManageTargetScreen',
	    		editable: false,
	    		valueField: 'id',
	    		displayField: 'value',
                allowBlank: true,
                hidden:true,
	    		forceSelection:true,
	    	}]
        },{
        	xtype : 'fieldcontainer',
    		width : 'auto',
    		layout : {
    			type : 'hbox'
    		},
    		cls: 'customSearchPanelBtnsFieldContainerCls',
        items: [{
            xtype: 'button',
            text: getCommonTranslation('SEARCH'),
            itemId: 'searchBtnTargetByStaffItemId',
            buttonAlign: 'left',
            ui: 'CustomBtnSubmit',
            scale: CONSTANTS.BUTTONSIZE,
            formBind: true
        }, {
            xtype: 'button',
            itemId: 'resetBtnTargetByStaffItemId',
            text: getCommonTranslation('RESET'),
            ui: 'CustomBtnCancel',
            scale: CONSTANTS.BUTTONSIZE
        }]
    }]
});