/**
 *  @author Ramkrishna Yadav
 */

Ext.define('Academia.view.mangeElections.candidate.CandidateGrid', {
	//extend : 'Ext.grid.Panel',
	extend: 'Academia.view.facilitiesresources.resourcebooking.StaticGridExcelExport',
	alias : 'widget.candidategrid',
	store : 'election.election.ElectionCandidateGridStore',
	title: getCommonTranslation('CANDIDATE_LIST'),
	border: true,
	autoScroll: false,
	viewConfig : {
		stripeRows : CONSTANTS.STRIPEROWS
	},
	dockedItems : [{
		xtype : 'toolbar',
		dock : 'bottom',
		items : [{
			xtype: 'custompagingtoolbar',
			plugins:['pagesize'],
			store : 'election.election.ElectionCandidateGridStore',
			emptyMsg :getCommonTranslation('EMPTY_MESSAGE'),
			displayInfo : true
		}]
	}],
	initComponent: function() {
		var grid=this;                   
		grid.addExportToolBarItems(grid);
		this.callParent(arguments);     
	},
	tbar: [{
		xtype: 'button',
		itemId: 'btnAdd',
		tooltip: getTransportTranslation('ADD'),
		glyph: ICONGLYPH.ADDGLYPH
	},{
		xtype: 'button',
		itemId: 'btnEdit',
		tooltip: getTransportTranslation('EDIT'),
		glyph: ICONGLYPH.EDITGLYPH
	},{
		xtype: 'button',
		itemId: 'btnDelete',
		cls: 'CustomToolbarBtnReject',
		tooltip: getTransportTranslation('DELETE'),
		glyph: ICONGLYPH.DELETEGLYPH
	}],
	columns: [{
		header : getCommonTranslation('LIST_NAME'),
		dataIndex : 'nameInEnglish',
		flex:1
	},{
		header : getCommonTranslation('LIST_NAME_OTHER_LANG'),
		dataIndex : 'nameInOtherLanguage',
		flex:1
	},{
		header :getCommonTranslation('MAXIMUM_VOTES_LIST'),
		dataIndex : 'maximumVoteInList',
		flex:1
	},{
		header : getCommonTranslation('STATUS'),
		dataIndex : 'isActive',
		flex:1,
		renderer: function(value, metadata, record) {
			var status='Active';
			if(value==false)
				status='InActive';
			return status;
		}
	}]
});