/**
 *  @author Ramkrishna Yadav
 */

Ext.define('Academia.view.mangeElections.candidate.CandidatesInformationGrid', {
	//extend : 'Ext.grid.Panel',
	extend: 'Academia.view.facilitiesresources.resourcebooking.StaticGridExcelExport',
	alias : 'widget.candidatesinformationgrid',
	store : 'election.election.ElectionCandidateInfoGridStore',
	title: getCommonTranslation('CANDIDATES_INFORMATION'),
	border: true,
	autoScroll: false,
	viewConfig : {
		stripeRows : CONSTANTS.STRIPEROWS
	},
	dockedItems : [{
		xtype : 'toolbar',
		dock : 'bottom',
		items : [{
			xtype: 'custompagingtoolbar',
			plugins:['pagesize'],
			store : 'election.election.ElectionCandidateInfoGridStore',
			emptyMsg :getCommonTranslation('EMPTY_MESSAGE'),
			displayInfo : true
		}]
	}],
	initComponent: function() {
		var grid=this;                   
		grid.addExportToolBarItems(grid);
		this.callParent(arguments);     
	},
	tbar: [{
		xtype: 'button',
		itemId: 'btnAdd',
		tooltip: getCommonTranslation('ADD'),
		glyph: ICONGLYPH.ADDGLYPH
	},{
		xtype: 'button',
		itemId: 'btnEdit',
		tooltip: getCommonTranslation('EDIT'),
		glyph: ICONGLYPH.EDITGLYPH
	},{
		xtype: 'button',
		itemId: 'btnDelete',
		cls: 'CustomToolbarBtnReject',
		tooltip: getCommonTranslation('DELETE'),
		glyph: ICONGLYPH.DELETEGLYPH
	}],
	columns: [{
		header : getAdmissionTranslation('CANDIDATE_NAME'),
		dataIndex : 'candidateName',
		flex:1
	},{
		header : getCommonTranslation('CANDIDATE_TYPE'),
		dataIndex : 'candidateType',
		flex:1,
		renderer: function(value) {
			var resCan=value;
			if(value=="STUDENTS"){
				resCan=	getCommonTranslation('STUDENTS')
			}else if(value=="STAFF_USERS"){
				resCan=	getCommonTranslation('STAFF_USERS')
			}else{
				resCan=	getCommonTranslation('EXTERNAL_USERS')
			}
			return resCan;
		}
	},{
		header : getCommonTranslation('EMAIL_ID'),
		dataIndex : 'emailId',
		flex:1
	},{
		header : getCommonTranslation('CANDIDATE_PHONE_NUMBER'),
		dataIndex : 'mobileNumber',
		flex:1,
		renderer : function(value, metadata, record) {
			
			var val = value;
			if(record.data.mobileCountryCode!=null) {
				val = record.data.mobileCountryCode+ "-" + value;
			}
			return val;
		}
	}]
});