/**
 * @author Ramkrishna Yadav
 * 
 */
Ext.define('Academia.view.mangeElections.copyElection.CopyElectionWin',{
	extend: 'Ext.window.Window',
	alias : 'widget.copyelectionwin',
	title: getCommonTranslation('ELECTION_COPY'),
	frame: true,
	formCode:'copyelectionform',
	autoScroll: true,
	modal:true,
	  method: 'POST',
	 items: [{
		xtype: 'idgeneratorformwin',
		itemId:'copyelectionform',
		plugins : "formlabelrequired",
		defaults: {
			labelAlign: 'top',
			width: 256
		},
	items : [{
		xtype : 'fieldcontainer',
		width : '100%',
		layout : {
			type : 'hbox'
		},
		defaults : {
			width : 240,
			labelAlign : 'top'
		},
		items : [{
			xtype: 'hidden',
			itemId:'idItemId',
			name: 'id'
		}, {
			xtype : 'textfield',
			name : 'electionCode',
			itemId:'electionCodeItemId',
			fieldLabel : getCommonTranslation("NEW_ELECTION_CODE"),
			emptyText: getCommonTranslation('ID_AUTOGENERATE'),
		   readOnly:true,
			
			
		},{
			xtype: 'customcombobox',
			fieldLabel: getCommonTranslation("NEW_ELECTION_TYPE"),
			name: 'electionType',
			itemId:'electionType',
			editable: true,
			store: 'election.election.ElectionTypeStore',
			displayField: 'value',
			valueField: 'id',
			minChars:3,
			editable : false,
			typeAhead:true,
			forceSelection :true,
			queryParam:'qry',
			allowBlank:false,
			
		},{
			xtype : 'textfield',
			name : 'electionName',
			itemId:'electionNameItemId',
			fieldLabel : getCommonTranslation("NEW_ELECTION_NAME"),
			allowBlank:false,
			maxLength: 100
		}]

	},{
		xtype : 'fieldcontainer',
		width : '100%',
		layout : {
			type : 'hbox'
		},
		defaults : {
			width : 240,
			labelAlign : 'top'
		},
		items : [{
			xtype: 'hidden',
			itemId:'idItemId',
			name: 'id'
		}, {
			xtype : 'customcombobox',
			//width: 256,
			fieldLabel : getCommonTranslation('ACADEMIC_TERM'),		
			name : 'academicTerm',
			itemId : 'academicTerm',
			displayField : 'value',
			store:Ext.create('Academia.store.common.AcademicTermStoreForIntakeYearId'),
			valueField : 'id',
			allowBlank:false,
		//	triggerCls : Ext.baseCSSPrefix + 'form-search-trigger',
			minChars:3,
			emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
			typeAhead:true,
			editable: true,
			triggerAction: 'all',
			 queryParam:'qry',
			forceSelection:true,
			listConfig: {
				listeners: {
					beforeshow: function(picker) {
						picker.minWidth = picker.up('combobox').getSize().width;
					}
				},
				loadingText: getCommonTranslation('SEARCHING'),
				emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
				getInnerTpl: function() {
					return '<div class="search-item">' +
					'{value}' +
					'</div>';
				}
			}
		},{
			xtype: 'textarea',
			name:'electionDescription',
			itemId:'electionDescriptionItemId',
			width: 465,
			maxLength : 5000,
			allowBlank:false,
			fieldLabel: getCommonTranslation('ELECTION_DESCRIPTION')
		}]

	} ,{
		xtype : 'fieldcontainer',
		width : '100%',
		layout : {
			type : 'hbox'
		},
		defaults : {
			width : 240,
			labelAlign : 'top'
		},
		items : [{
			xtype : 'textfield',
			name : 'electionNameInOtherLang',
			itemId:'electionNameInOtherLangItemId',
			fieldLabel : getCommonTranslation("ELECTION_NAME_IN_OTHER_LANG"),
			
			
		},{
			xtype: 'textarea',
			name:'electionDescriptionInOtherLang',
			itemId:'electionDescriptionInOtherLang',
			width: 465,
			maxLength : 5000,
			fieldLabel: getCommonTranslation('ELECTION_DESCRIPTION_IN_OTHER_LANG')
		}]

	},{
		xtype: 'fieldcontainer',
		layout: 'hbox',
		defaults: {
			width: 256,
			labelAlign: 'top'
		},
		items: [{
            xtype: 'radiogroup',
            itemId: 'status',
            name: 'status',
            fieldLabel: getCommonTranslation('IS_ACTIVE'),
            columns: 2,
            width: '250px',
            //labelWidth: 'auto',
            vertical: false,
            layout: {
            	type: 'hbox'
            },
            items: [{
                boxLabel: getCommonTranslation('YES'),
                name: 'isActive',
                itemId: 'statusYesItemId',
                width: 100,
                inputValue: true,
               checked: true
            }, {
                boxLabel: getCommonTranslation('NO'),
                name: 'isActive',
                itemId: 'statusNoItemId',
                width: 100,
                inputValue: false,
                
            }]
		}]
	},{
		xtype: 'fieldcontainer',    
		layout : {
			type : 'hbox'
		},
		width:'auto',
		items : [{
			xtype : 'button',
			text : getCommonTranslation("SAVE") ,
			itemId : 'submitBtn',
			ui : 'CustomBtnSubmit',
			scale : CONSTANTS.BUTTONSIZE,
			formBind : true
		},{
			xtype: 'button',
			text: getFeeAndPaymentCommonTranslation('CANCEL'),
			ui: 'CustomBtnCancel',
			itemId: 'CancelBtnCopyElection',
			scale: CONSTANTS.BUTTONSIZE
		}]
	}]
	}]
});
