/**
 * @author prathamesh.sheth
 * 
 * This is the Adhoc approve/reject/resubmit form panel.   
 *   
 * 
 */
Ext.define('Academia.view.messaging.AdhocApproveRejectFormPanel',{
	extend:'Ext.form.Panel',
	alias:'widget.adhocapproverejectformpanel',
	autoScroll:false,
	frame: true,	
	plugins : "formlabelrequired",	
	items:[{
            xtype: 'fieldcontainer',
            layout: 'vbox',        
            width:'100%',
            items: [{
                xtype: 'textareafield',
                name: 'reviewComment',
                itemId:'adhocReviewCommentTxtArea',
                //emptyText: getMessagingModuleTranslation('REVIEW_REMARK'),
                maxLength: 500,
                hidden:true,
                disabled:true,
                width:'50%',
                allowBlank: false,
                listeners: {
                	blur: function(field, newValue, oldValue, eOpts){
                		field.setValue(field.getValue().trim());
                	}
                }
            }]
    	},{
            xtype: 'fieldcontainer',
            layout: {
        		type: 'hbox'
        	}, 
        	items: [{
                xtype: 'button',
                itemId: 'btnAdhocApproveReviewComment',                   
                text:getMessagingModuleTranslation('APPROVE'), //Approve
                ui: 'CustomBtnSubmit',
                hidden:true,
                disabled:true,
                status:CONSTANTS.MSG_TEMP_APPROVED,  //APPROVED                
                scale: CONSTANTS.BUTTONSIZE
            },{
                xtype: 'button',
                itemId: 'btnAdhocRejectReviewComment',                    
                text:getMessagingModuleTranslation('REJECT'), //Reject
                ui: 'CustomBtnSubmit',
                hidden:true,
                disabled:true,
                status:CONSTANTS.MSG_TEMP_REJECTED,  //REJECTED
                scale: CONSTANTS.BUTTONSIZE
            },{
                xtype: 'button',
                itemId: 'btnAdhocReSubmitForApprovalComment',                    
                text:getMessagingModuleTranslation('RESUBMIT_FOR_APPROVAL'), //ReSubmit for Approval
                ui: 'CustomBtnSubmit',
                hidden:true,
                disabled:true,
                status:CONSTANTS.MSG_TEMP_RESUBMIT_FOR_APPROVAL,  //RESUBMIT_FOR_APPROVAL
                scale: CONSTANTS.BUTTONSIZE
            }]
    	}]
});