/**
 * @author prathamesh.sheth
 * 
 * This component is used for to show Adhoc Messaging reports in grid.
 *  
 */
Ext.define('Academia.view.messaging.AdhocMessagingReportPanel', {
    extend: 'Ext.grid.Panel',
    alias: 'widget.adhocmessagingreportpanel',
    border: true,
    autoScroll:true,
    maxHeight:200,
    title: getMessagingModuleTranslation('ADHOC_MESSAGING_DOCUMENTS'), //Adhoc Messaging Documents		
    columns: [/*{
        header: getMessagingModuleTranslation('DOCUMENT_ID'), //Document ID
        dataIndex: 'dydtOwnerCnfgId',
        flex: .3
    },*/{
        header: getMessagingModuleTranslation('DOCUMENT_NAME'), //Document Type
        dataIndex: 'documentTypeName',
        flex: .3
    }, {
        header: getMessagingModuleTranslation('DOC_TEMPLATE_NAME'), //Document Name
        dataIndex: 'templateName',
        flex: .3
    }],
    initComponent: function() {
        Ext.apply(this, {
            store: Ext.create('Academia.store.messaging.AdhocMessagingReportGridStore'),
            viewConfig: {
                stripeRows: CONSTANTS.STRIPEROWS
            }
        });
        this.callParent(arguments);
    },
    tbar: [{
        xtype: 'button',
        itemId: 'btnAddAdhocMessagingReport',
        tooltip: getCommonTranslation('ADD'), //Add
        glyph: ICONGLYPH.ADDGLYPH
    }/*, {
        xtype: 'button',
        itemId: 'btnEdit',        
        tooltip: getCommonTranslation('EDIT'), //Edit
        glyph: ICONGLYPH.EDITGLYPH
    }, {
        xtype: 'button',
        itemId: 'btnView',
        tooltip: getCommonTranslation('VIEW'), //View
        iconCls: 'view-icon'
    }*/, {
        xtype: 'button',
        itemId: 'btnDeleteAdhocMessagingReport',
        cls: 'CustomToolbarBtnReject',        
        tooltip: getCommonTranslation('DELETE'), //Delete
        glyph: ICONGLYPH.DELETEGLYPH
    }]    
});