/**
 * @author Pravin.Surve
 * Form for Adhoc messaging set up form
 */
Ext.define('Academia.view.messaging.AdhocMessaheBasicSetUpForm', {
    extend: 'Ext.form.Panel',
    alias: 'widget.adhocmessahebasicsetupform',
    border: true,
    autoScroll : true,
    plugins: "formlabelrequired",    
    items: [{ xtype: 'form',
              title: getMessagingModuleTranslation('BASIC_CONFIGURATION'),
              collapsed: false,
              frame:true,
              style :{
            	  marginLeft : '15px'
              },
              items : [{
            xtype: 'fieldcontainer',
            layout: 'hbox',
            defaults: {
                labelAlign: 'top',
                width: 256
            },
            style:{
            	marginLeft: '15px'
            },
            items: [{
            	xtype:'hidden',
            	name:'adhocMessageID',
            	itemId:'adhocMessageID'
            },{
            	xtype:'hidden',
            	name:'adhocMessageStatus',
            	itemId:'adhocMessageStatus'
            },{
            	xtype:'hidden',
            	name:'messageTemplates',
            	itemId:'messageTemplates'
            },{    	    
        		xtype:'hidden',
        		name:'wsMsgEventRecipientConfigs',
        		itemId:'wsMsgEventRecipientConfigs'	        		        		
        	},{    	    
        		xtype:'hidden',
        		name:'wsAdhocRecipients',
        		itemId:'wsAdhocRecipients'	        		        		
        	},{
                xtype: 'textfield',
                fieldLabel: getMessagingModuleTranslation('MESSAGE_CODE'),
                name: 'messageId',
                itemId: 'messageId',
                allowBlank: false
            },{
                xtype: 'textfield',
                fieldLabel: getMessagingModuleTranslation('MESSAGE_NAME'),
                name: 'displayCode',
                itemId: 'messageName',
                allowBlank: false
            }]
        }, {
            xtype: 'fieldcontainer',
            layout: 'hbox',
            defaults: {
                labelAlign: 'top',
                width: 256
            },
            style:{
            	marginLeft: '15px'
            },            
            items: [{
                xtype: 'customcombobox',
                fieldLabel: getMessagingModuleTranslation('MESSAGE_CATEGORY'),                
                store: 'messaging.MessageCategoryStore',
                editable: false,
                name: 'msgCategoryId',
                itemId: 'adhocMessageCategory',
                valueField: 'id',                
                displayField: 'code',
                queryMode: 'local',
                allowBlank: false
            },{
                xtype: 'customcombobox',
                fieldLabel: getMessagingModuleTranslation('MESSAGE_SUBCATEGORY'),                                
                editable: false,
                name: 'msgSubCategoryId',
                itemId: 'adhocMessageSubCategory',
                valueField: 'id',
                queryMode: 'local',
                displayField: 'code',
                allowBlank: false,
                listeners: {
                	render: function(combo){
                		var store = Ext.create('Academia.store.messaging.MessageSubCategoryStore');
                		combo.bindStore(store);
                	}
                }
            }]
        }, {
            xtype: 'fieldcontainer',
            width: '100%',
            layout: {
                type: 'hbox'
            },
            style:{
            	marginLeft: '15px'
            },
            defaultType: 'checkboxfield',
            items: [{                
                boxLabel: getMessagingModuleTranslation('IS_TEMPLATE_CUSTOMIZE'),
                name: 'IS_TEMPLATE_CUSTOMIZE',
                itemId:'isAdhocCustomizeTemplate',
                inputValue: true,
                uncheckedValue: false
            }]
        },{
            xtype: 'fieldcontainer',
            width: '100%',
            layout: {
                type: 'hbox'
            },
            style:{
            	marginLeft: '15px'
            },
            defaults: {
                labelAlign: 'top',
                width: 256},
            items: [{
                xtype: 'customcombobox',
                fieldLabel: getMessagingModuleTranslation('SELECT_TEMPLATE'),
//                store: 'messaging.MessageTemplate',
                editable: false,
                allowBlank: false,
                name: 'msgTemplateConfigId',
                itemId: 'selectTemplate',
                valueField: 'id',
                queryMode: 'local',
                displayField: 'code',
                listeners: {
                	render: function(combo){
                		var store = Ext.create('Academia.store.messaging.MessageTemplate');
                		combo.bindStore(store);
                	}
                }
                
            }]
        },{
            xtype: 'fieldcontainer',
            width: 'auto',
            style:{
            	marginLeft: '15px'
            },
            items: [{
                xtype: 'radiogroup',
                fieldLabel: getMessagingModuleTranslation('SENDING_PRIORITY'), //+' <span class="required" style="color:red"> *</span>',
                itemId: 'sendingPriority',
                name:'sendingPriority',
                width: 500,
                labelAlign:'top',
                vertical: false,
                allowBlank : false,
                layout: {
                    type: 'hbox'
                },
                items: [{
                    boxLabel: getMessagingModuleTranslation('IMMEDIATE'),
                    itemId: 'immediate',
                    name: 'sendingPriority',
                    inputValue: 'IMMEDIATE',
                    checked: true
                }, {
                    boxLabel: getMessagingModuleTranslation('SCHEDULE'),
                    itemId: 'schedule',
                    name: 'sendingPriority',
                    inputValue: 'SCHEDULE'
                }]
            }]
        },{
            xtype: 'fieldcontainer',
            width: '100%',
            style:{
            	marginLeft: '15px'
            },
            layout: {
                type: 'hbox'
            },
            defaults: {
                labelAlign: 'top',
                width: 256
                },
            items: [{
                xtype: 'datefield',
                fieldLabel: getMessagingModuleTranslation('SCHEDULE_DATE'),
                name: 'msgDueDate',
                hidden: true,
                editable: false,
                itemId: 'scheduleDate',
                listeners: {
                	render: function(field) {
                		return dateFormatRender(field);
                	}
                },
                minValue: new Date(),
                //--submitFormat: CONSTANTS.SUBMIT_DATE_FORMAT
            },{
                xtype: 'timefield',
                name: 'msgDueDateTime',
                itemId: 'scheduleTime',
                hidden: true,
                fieldLabel: getMessagingModuleTranslation('SCHEDULE_TIME'),
                format: CONSTANTS.DISPLAY_TIME_FORMAT,                
                increment: 30,
                minValue:Ext.Date.format(new Date(),CONSTANTS.DISPLAY_TIME_FORMAT),
                editable: false
            }]        
    },{
        xtype: 'fieldcontainer',
        width: '100%',
        style:{
        	marginLeft: '15px'
        },
        layout: {
            type: 'vbox'
        },
        items: [{
            xtype: 'checkboxfield',
            boxLabel: getMessagingModuleTranslation('APPROVAL_REQUIRED'),
            name: 'approvalRequired',
            itemId:'isAdhocApprovalRequired',                
            inputValue: true,
            uncheckedValue: false,
            width: 256
        }, {
            xtype: 'livesearchcombo',
            name: 'approverId',
            width: 256,
            hidden:true,
            store:'Academia.store.messaging.ApprovarComboStore',
            labelAlign: 'top',
            allowBlank: false,
            fieldLabel: getMessagingModuleTranslation('APPROVER'),
            itemId: 'adhocApprover' 
        }]

    }, {
    	xtype:'adhocmessagesubtabpanel',
        itemId:'templateConfiguarationTabPanel',
        minHeight:300,
        minWidth:1100
    },{ 	
    	style:{
        	marginLeft:CONSTANTS.MARGIN_LEFT_FOR_FORM
        },
		xtype:'adhocapproverejectpanel',
		itemId:'adhocApproveRejectPanel',
		title:getMessagingModuleTranslation('COMMENT'),
		collapsible:true,
		collapsed:false
	}, {
        xtype: 'fieldcontainer',
        width: '100%',
        style: {            
            marginLeft: '15px'                
        },
        items: [{
            xtype: 'button',
            text: getMessagingModuleTranslation('SUBMIT'),
            itemId: 'adhocMsgSubmitBtn',
            buttonAlign: 'right',
            ui: 'CustomBtnSubmit',
            scale: CONSTANTS.BUTTONSIZE,
            //formBind: true
        },{
            xtype: 'button',
            itemId: 'btnadhocSendForApproval',                   
            text:getMessagingModuleTranslation('SEND_FOR_APPROVAL'), //Send for Approval
            ui: 'CustomBtnSubmit',
            hidden:true,
            disabled:true,
            status:CONSTANTS.MSG_TEMP_SENT_FOR_APPROVAL,  //Sent for Approval
            scale: CONSTANTS.BUTTONSIZE
        },{
            xtype: 'button',
            text: getServiceRequestTranslation('CLEAR_SEARCH'),
            ui: 'CustomBtnCancel',
            itemId: 'adhocMsgCancelBtn',
            scale: CONSTANTS.BUTTONSIZE
        }]
    }]
    }]
});
