/**
 * @author prathamesh.sheth
 * 
 * This is the System event configuration message scopes 
 *   
 * */
Ext.define('Academia.view.messaging.SystemEventConfigMessageScopes',{
	extend:'Ext.form.Panel',
	alias:'widget.systemeventconfigmessagescopes',
	autoScroll:false,
	frame: true,
	plugins : "formlabelrequired",
	initComponent: function() {
		var this$ = this;     
		
        var store = this$.buildStore();
        
        this$.items = [{
            xtype: 'fieldcontainer',
            width: '100%',
            layout: {
                type: 'hbox'
            },
            defaults: {
                labelAlign: 'top',
                width: 256
            },
            style:{
            	marginLeft:'10px'
            },
            items: [{
            	xtype:'hidden',
            	name:'id',
            	itemId:'id'
            },{
                xtype: 'customcombobox',
                fieldLabel: getMessagingModuleTranslation('MESSAGE_SCOPE'),            
//                store: 'messaging.MessageEntity',
                editable: false,
                name: 'msgScopeParamId',
                itemId: 'messageScopeCombo',            
                valueField: 'id',                
                displayField: 'value',
                queryMode: 'local',
                listeners: {
                	render: function(combo){
                		var store = Ext.create('Academia.store.messaging.MessageEntity');
                		combo.bindStore(store);
                	}
                }
            },{
                xtype: 'button',
                itemId: 'btnSaveMessageScopeForm',
                text: getCommonTranslation('SAVE'),
                ui: 'CustomBtnCancel',
                style:{
                	marginTop:'30px'
                },                
                scale: CONSTANTS.BUTTONSIZE
            }]
        },{
            xtype: 'fieldcontainer',
            width: '100%',
            layout: {
                type: 'hbox'
            },        
            items: [{
                xtype: 'itemselector',
                cls: 'itemSelectorCls',
                name: 'msgEventScopeRecords',
                itemId: 'messageScopeSelector',
                valueField: 'id',
                displayField: 'value',
                store:store,
                width: 500,
                height: 400,            
                buttons: ['add', 'remove'],
                msgTarget: 'side',
                fromTitle: getMessagingModuleTranslation('AVALIABLE_ITEMS'),
                toTitle: getMessagingModuleTranslation('SELECTED_ITEMS')        
            }]
        }];
        
        this$.callParent(arguments);
	},
    buildStore: function() {
        return Ext.create('Academia.store.messaging.SystemEventConfigSelectorStore');
    }
});