/**
 * @author pritam.patil
 * this is Quick search Form Of List Of System Events in messaging 
 */
Ext.define('Academia.view.messaging.SystemEventsSearchForm', {
    extend: 'Ext.form.Panel',
    alias: 'widget.systemeventssearchform',
    frame: false,
    cls:'customSearchPanel',
    //title: getMessagingModuleTranslation('QUICK_SEARCH'),    
    items: [{
        xtype: 'fieldcontainer',
        layout: 'hbox',
        defaults: {
            labelAlign: 'top',
            width: 256
        },
        items: [{
    			xtype: 'customcombobox',
    			name: 'EVENT_CODE',
                itemId:'eventCode',
                fieldLabel: getMessagingModuleTranslation('EVENT_CODE'),
            	store:'messaging.MessageSystemEventCodeStore',
    			valueField: 'code',
    			displayField: 'value',
    			queryParam:'qry',
    			minChars:3,
    			allowBlank: true,
    			typeAhead:false,
                emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
                forceSelection:true,
    			  listConfig: {
    				  listeners: {
    						beforeshow: function(picker) {
    							picker.minWidth = picker.up('combobox').getSize().width;
    						}
    					},
    	                loadingText: getCommonTranslation('SEARCHING'),
    	                emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
    	                getInnerTpl: function() {
    	                    return '<div class="search-item">' +
    	                        '{value}' +
    	                    '</div>';
    	                }
    	            }
			    /*xtype: 'textfield',
			    fieldLabel: getMessagingModuleTranslation('EVENT_CODE'),
			    
			    name: 'EVENT_CODE'*/
    		
        },{
            xtype: 'customcombobox',
            fieldLabel: getMessagingModuleTranslation('CONFIG_LEVEL'),
            
            store: 'messaging.ConfigLevels',
            editable: false,
            name: 'CONFIG_LEVEL',
            itemId: 'configLevelId',
            valueField: 'name',
            queryMode: 'local',
            displayField: 'value'
        }]
    }, {
        xtype: 'fieldcontainer',
        layout: 'hbox',
        defaults: {
            labelAlign: 'top',
            width: 256
        },
        items: [{
        	xtype: 'multiselectcombofield',
        	fieldLabel: getCommonTranslation('ACADEMY_LOCATION'),
        	store: 'Academia.store.common.AcademyLocationNameSeparated',
        	cls:'multiBrandCampusCls',
        	name:'ACADEMY_LOCATION_ID',
        	itemId: 'ACADEMY_LOCATION',
            displayField: 'value',
            valueField: 'id',
//            hidden:true,
            disabled:true,
            width:462,
            queryMode: 'local',
    		typeAhead: true,
            editable: true,
            inputHeight: '30px' ,
            height:50,
            maxHeight:300,
            value : 'All'
    },{
        xtype: 'checkboxfield',
        boxLabel: getMessagingModuleTranslation('WHETHER_ENABLED'),
        style: {
            marginTop: '40px'
        },
        name: 'WHETHER_ENABLED',
        //checked:true,
        inputValue: 'true',
        //uncheckedValue: 'false'
    }]
    }, {
        xtype: 'fieldcontainer',
        width: '100%',
		layout : {
			type : 'hbox'
		},
		cls: 'customSearchPanelBtnsFieldContainerCls',
        items: [{
            xtype: 'button',
            text: getMessagingModuleTranslation('SEARCH'),
            itemId: 'systemEventFindButtonId',
            //buttonAlign: 'right',
            ui: 'CustomBtnSubmit',
            scale: CONSTANTS.BUTTONSIZE
        }, {
            xtype: 'button',
            text: getMessagingModuleTranslation('CLEAR_SEARCH'),
            itemId: 'systemEventClearSearch',
            //buttonAlign: 'right',
            ui: 'CustomBtnCancel',
            scale: CONSTANTS.BUTTONSIZE
        }]
    }]
});