/**
 * @author pritam.patil
 * this is Of template Basic set up in messaging 
 */
Ext.define('Academia.view.messaging.TemplateBasicSetUpForm', {
    extend: 'Ext.form.Panel',
    alias: 'widget.templatebasicsetupform',
    border: true,
    autoScroll : true,
    plugins: "formlabelrequired",
    cls:'x-form-fixed-footer-parent',
    items: [{ xtype: 'form',
             title: getMessagingModuleTranslation('BASIC_CONFIGURATION'),
             collapsed: false,
             frame:true,
             margin: '16px',
             items : [{
        xtype: 'fieldset',
        itemId: 'basicConfigurationFieldSet',
        collapsed: false,
        style: {
            marginLeft: '10px',
            marginTop: '2px ! important'
        },
        items: [{
            xtype: 'fieldcontainer',
            layout: 'hbox',
            defaults: {
                labelAlign: 'top',
                width: 256
            },
            items: [{
            	xtype:'hidden',
            	name:'id',
            	itemId:'ID'
            },{
            	xtype:'hidden',
            	name:'messageTemplates',
            	itemId:'messageTemplates'
            },{
                xtype: 'textfield',
                fieldLabel: getMessagingModuleTranslation('TEMPLATE_CODE'),
                itemId:'templateCode',
                name: 'code',                
                allowBlank: false
            },{
                xtype: 'textfield',
                fieldLabel: getMessagingModuleTranslation('TEMPLATE_NAME'),
                itemId:'templateConfigName',
                name: 'templateConfigName',
                allowBlank: false
            },{
                xtype: 'textfield',
                fieldLabel: getMessagingModuleTranslation('SMS_TEMPLATE_ID'),
                itemId:'templateId',
                name: 'templateId'
            }]
        }, {
            xtype: 'fieldcontainer',
            layout: 'hbox',
            defaults: {
                labelAlign: 'top',
                width: 256
            },
            items: [{
                xtype: 'customcombobox',
                fieldLabel: getMessagingModuleTranslation('MESSAGE_CATEGORY'),
                store: 'messaging.MessageCategoryStore',
                editable: false,
                name: 'msgCategoryId',
                itemId: 'messageCategory',
                valueField: 'id',                
                displayField: 'code',
                queryMode: 'local',
                allowBlank: false
            },{
                xtype: 'customcombobox',
                fieldLabel: getMessagingModuleTranslation('MESSAGE_SUBCATEGORY'),
                editable: false,
                store:'messaging.MessageSubCategoryStore',
                name: 'msgSubCategoryId',
                itemId: 'messageSubCategory',
                valueField: 'id',
                queryMode: 'local',
                displayField: 'code',
                allowBlank: false,
              /*  listeners: {
                	render: function(combo){
                		var store = Ext.create('Academia.store.messaging.MessageSubCategoryStore');
                		combo.bindStore(store);
                	}
                }*/
            },{
                xtype: 'customcombobox',
                fieldLabel: getCommonTranslation('MESSAGE_LANGUAGE'),            
                store: Ext.create('Academia.store.messaging.MessageLanguageComboStore'),
                editable: false,
                name: 'MESSAGE_LANGUAGE',
                itemId: 'msgLanguageCombo',
                allowBlank: false,
                valueField: 'code',
                displayField: 'code'
            }]
        },{
            xtype: 'fieldcontainer',
            width: '100%',
            layout: {
                type: 'hbox'
            },
            defaults: {
                labelAlign: 'top',
               // width: 256
            },
            items: [{
                xtype: 'radiogroup',
                itemId: 'messageTemplateType',
                name:'messageTemplateType',
//                width: 600,
                style:{
                	marginLeft:'-3px'
                },
                vertical: false,
                layout: {
                    type: 'hbox'
                },
                items: [{
                    boxLabel: getMessagingModuleTranslation('SYSTEM_EVENT_TEMPLATE'),
                    itemId: 'systemEventTemplate',
                    name: 'messageTemplateType',
                    inputValue: 'SYSTEM_EVENT_TEMPLATE',
                    style: { marginRight: '64px' }
                },{
                    boxLabel: getMessagingModuleTranslation('ADHOC_MESSAGE_TEMPLATE'),
                    itemId: 'adhocMessageTemplate',
                    name: 'messageTemplateType',
                    inputValue: 'ADHOC_MESSAGE_TEMPLATE',
                    checked: true,
                    width: 256
                    
                }]
            }]
        },{
            xtype: 'fieldcontainer',
            width: '100%',
            layout: {
                type: 'hbox'
            },
            defaults: {
                labelAlign: 'top',
               // width: 226
            },
            items: [{
                xtype: 'customcombobox',
                fieldLabel: getMessagingModuleTranslation('SYSTEM_MESSAGE_EVENT'),                
                editable: false,
                store:'messaging.SystemMessageEvent',
                name: 'systemMsgEventId',
                itemId: 'systemMsgEventCombo',
                disabled:true,
                valueField: 'id',
                queryMode: 'local',
                displayField: 'displayCode',
                width: 256,
              /*  listeners: {
                	render: function(combo){
                		var store = Ext.create('Academia.store.messaging.SystemMessageEvent');
                		combo.bindStore(store);
                	}
                }*/
            }]
        }
        ,{
            xtype: 'fieldcontainer',
            width: '100%',
            layout: {
                type: 'hbox'
            },       
            defaults: {
                labelAlign: 'top',
                width: 256
            },
            items: [{
            	xtype: 'checkboxfield',
                boxLabel: getMessagingModuleTranslation('IS_STATIC_TEMPLATE'),
                name: 'whetherStaticMsg',                
                itemId:'isStaticTemplate', 
                /*style: {
                    marginTop: '25px',
                    marginLeft:'0px'
                },*/
                inputValue: true,
                uncheckedValue: false
            }, {                
            	xtype: 'checkboxfield',
                boxLabel: /*'<div>Is template customized </div>'+'<div>for each recipient type ?</div>',*/getMessagingModuleTranslation('IS_TEMPLATE_CUSTOMIZE'),
                name: 'IS_TEMPLATE_CUSTOMIZE',
                itemId:'isCustomizeTemplate',
                inputValue: true,
                uncheckedValue: false,
                labelWidth: 200
            }]
        }, {
            xtype: 'fieldcontainer',
            width: '100%',
            layout: {
                type: 'hbox'
            },
            defaults: {
                labelAlign: 'top',
                width: 256
            },
            items: [{
                xtype: 'customcombobox',
                fieldLabel: getMessagingModuleTranslation('TEMPLATE_DATA_PROVIDER'),                                
                editable: false,
                store:'messaging.TemplateDataProvider',
                name: 'templateDataProviderId',
                itemId: 'templateDataProvider',
                valueField: 'id',
                queryMode: 'local',
                displayField: 'dataProviderName',                
                //allowBlank: false,
                    /*listeners: {
                    	render: function(combo){
                    		var store = Ext.create('Academia.store.messaging.TemplateDataProvider');
                    		combo.bindStore(store);
                    	}
                    }*/
            }, {
                xtype: 'customcombobox',
                fieldLabel: getMessagingModuleTranslation('RECEIPENT_TYPE'),                
                editable: false,
                store:'messaging.RecipientTypeByEventId',
                name: 'recipientTypeId',
                itemId: 'recipientType',
                disabled:true,
                valueField: 'id',
                queryMode: 'local',
                displayField: 'code',
               /* listeners: {
                	render: function(combo){
                		var store = Ext.create('Academia.store.messaging.RecipientTypeByEventId');
                		combo.bindStore(store);
                	}
                }*/
            }]
        }, {
            xtype: 'fieldcontainer',
            width: '100%',
            layout: {
                type: 'hbox'
            },
            defaults: {
                labelAlign: 'top',
                width: 256
            },
            items: [{
                xtype: 'customcombobox',
                fieldLabel: getMessagingModuleTranslation('MESSAGE_TYPE'),                
                store: 'messaging.MessageTypeStore',
                editable: false,
                name: 'msgMessageTypeId',
                itemId: 'messageTypes',
                valueField: 'id',                
                displayField: 'code',
                //queryMode: 'local',
                allowBlank: false
            },{
                xtype: 'fieldcontainer',
                fieldLabel: getMessagingModuleTranslation('MESSAGE_MODE'),
                itemId:'messageModeGroupContainer',
                disabled:true,
                width: '100%',
                layout: {
                    type: 'hbox'
                },                                
                allowBlank: false,
                items: [{
                    xtype: 'checkboxgroup',
                    itemId:'messageModeGrp',       
                    width: '100%',
                    items: [{
            			xtype:'checkbox',
            			boxLabel: getMessagingModuleTranslation('EMAIL'),
	                    name: 'EMAIL',
	                    inputValue: 'EMAIL',
	                    itemId: 'EMAIL',
	                    checkBoxId: 1,
	                    whetherMsgSubjAvail:true,
	                    whetherAttachmentSupported:true
            		},{
            			xtype:'checkbox',
            			boxLabel: getMessagingModuleTranslation('SMS'),
	                    name: 'SMS', 
	                    inputValue: 'SMS',
	                    itemId: 'SMS',
	                    checkBoxId: 2,
	                    whetherMsgSubjAvail:false,
	                    whetherAttachmentSupported:false
            		},{
            			xtype:'checkbox',
            			boxLabel: getMessagingModuleTranslation('LETTER'),
	                    name: 'LETTER',
	                    inputValue: 'LETTER',
	                    itemId: 'LETTER',
	                    checkBoxId: 3,
	                    whetherMsgSubjAvail:true,
	                    whetherAttachmentSupported:false
            		},{
            			xtype:'checkbox',
            			boxLabel: getMessagingModuleTranslation('SYS_INTERNAL_MSG'),
	                    name: 'SYS_INTERNAL_MSG',
	                    inputValue: 'SYS_INTERNAL_MSG',
	                    itemId: 'SYS_INTERNAL_MSG',
	                    checkBoxId: 4,
	                    whetherMsgSubjAvail:true,
	                    whetherAttachmentSupported:false
            		},{
            			xtype:'checkbox',
            			boxLabel: getMessagingModuleTranslation('WEB_LINK'),
	                    name: 'WEB_LINK',
	                    inputValue: 'WEB_LINK',
	                    itemId: 'WEB_LINK',
	                    checkBoxId: 5,
	                    whetherMsgSubjAvail:true,
	                    whetherAttachmentSupported:false
            		},{
            			xtype:'checkbox',
            			boxLabel: getMessagingModuleTranslation('PUSH_NOTIFICATION'),
	                    name: 'PUSH_NOTIFICATION',
	                    inputValue: 'PUSH_NOTIFICATION',
	                    itemId: 'PUSH_NOTIFICATION',
	                    checkBoxId: 6,
	                    whetherMsgSubjAvail:true,
	                    whetherAttachmentSupported:false
            		}]
                }]
            }]
        },{
            xtype: 'fieldcontainer',
            width: '100%',
            layout: {
                type: 'hbox'
            },
            items: [{
                xtype: 'checkboxfield',
                boxLabel: getMessagingModuleTranslation('APPROVAL_REQUIRED'),
                name: 'approvalRequired',
                itemId:'isApprovalRequired',
                hidden:true,
                inputValue: true,
                uncheckedValue: false,
                width: 256,
                style: {
                    marginTop: '25px',
                    marginLeft:'0px'
                }

            }, {
                xtype: 'livesearchcombo',
                name: 'approverId',
                width: 256,
                disabled:true,
                store:'Academia.store.messaging.ApprovarComboStore',
                labelAlign: 'top',
                fieldLabel: getMessagingModuleTranslation('APPROVER'),
                itemId: 'approver',
                hidden:true,
                style:{
                	marginTop: '5px'
                }
            }]

        }]
    }, {
        xtype: 'templateconfiguarationtabpanel',
        itemId:'templateConfiguarationTabPanel',
        minHeight:500,
        minWidth:1100
    },{ 		
		xtype:'templateapproverejectpanel',
		itemId:'templateApproveRejectPanel',
		title:getMessagingModuleTranslation('COMMENT'),   //+'<span class="required" style="color:red"> *</span>',
		collapsible:true,
		collapsed:false
	}, {
        xtype: 'fieldcontainer',
        width: '100%',
        cls:'form-fixed-footer',
        items: [{
            xtype: 'button',
            text: getMessagingModuleTranslation('SUBMIT'),
            itemId: 'templateSubmitBtn',
            buttonAlign: 'right',
            ui: 'CustomBtnSubmit',
            scale: CONSTANTS.BUTTONSIZE,
            formBind: true
        },{
            xtype: 'button',
            itemId: 'btnSendForApproval',                   
            text:getMessagingModuleTranslation('SEND_FOR_APPROVAL'), //Send for Approval
            ui: 'CustomBtnSubmit',
            hidden:true,
            disabled:true,
            status:CONSTANTS.MSG_TEMP_SENT_FOR_APPROVAL,  //Sent for Approval
            scale: CONSTANTS.BUTTONSIZE
        }, {
            xtype: 'button',
            text: getServiceRequestTranslation('CLEAR_SEARCH'),
            ui: 'CustomBtnCancel',
            itemId: 'templateCancelBtn',
            scale: CONSTANTS.BUTTONSIZE
        }]
    	}]
    }]
});