/**
 *  @author Rajkumar.patidar
 */


Ext.define('Academia.view.messaging.report.SendMessageList', {
	extend: 'Ext.grid.Panel',
	alias : 'widget.sendmessagelist',
	store : 'messaging.SendMessageReportList',
	title: getMessagingModuleTranslation('SEND_MESSAGE_REPORT'),
	border: true,
	refreshStoreData:true,
	viewConfig : {
		stripeRows : CONSTANTS.STRIPEROWS
	},
	selType:'checkboxmodel',
    selModel: {
		multiSelect :true,
		mode:'SIMPLE',
		checkOnly : true,
		allowDeselect:true
	},
	 headerFix:{
			headerFix: true,
			portalIdsWithStructure: {
				'sendmessagereportstructure':1
			}
		},
	dockedItems : [{
		xtype : 'toolbar',
		dock : 'bottom',
		items : [{
			xtype: 'custompagingtoolbar',
			plugins:['pagesize'],
			store : 'messaging.SendMessageReportList',
			emptyMsg :getCommonTranslation('EMPTY_MESSAGE'),
			displayInfo : true
		}]
	}],
	/*initComponent: function() {
		var grid=this;    
		grid.addExportToolBarItems(grid,false);
		this.callParent(arguments); 
	},*/
	 tbar: ['->',{
         xtype: 'button',
         itemId: 'btnUnblockEmails',
         text: getMessagingModuleTranslation('UNBLOCK'),
         tooltip: getMessagingModuleTranslation('UNBLOCK'),
     }, {
	        xtype: 'button',
	        itemId: 'exportMessageSentReportItemId',
	        tooltip: getCommonTranslation('EXPORT_REPORT'),
	        text: getCommonTranslation('EXPORT_REPORT'),
	    }],
	columns: [{
		header : getMessagingModuleTranslation('RECIPIENT_NAME'),
		dataIndex : 'recipientFullName',
		flex:1
	},{
		header : getMessagingModuleTranslation('CONTACT'),
		dataIndex : 'contact',
		flex:1
	},{
		header : getMessagingModuleTranslation('LASTUPDATE'),
		dataIndex : 'lastUpdate',
		flex:1,
		renderer:function(date) {
			return dateRender(date)+'-'+timeRender(date);
		}
	},{
		header : getMessagingModuleTranslation('MSGCONTENT'),
		dataIndex : 'msgContent',
		flex : 1,
		renderer:function(value){
			return  '<a href="#">view</a>';
		}
	},{
		header : getMessagingModuleTranslation('SENT_BY'),
		dataIndex : 'sentBy',
		flex:1
	},{
		header : getMessagingModuleTranslation('STATUS'),
		dataIndex : 'deliveryStatus',
		flex:1,
		renderer:function(value){
			if(!isNullOrEmpty(value)){
				return  getMessagingModuleTranslation(value);
			}else{
				return "-";
			}
		}
	},{
		header : getMessagingModuleTranslation('DIAGNOSTIC_CODE_REASON'),
		dataIndex : 'diagnosticCode',
		flex:1
	},{
		header : getMessagingModuleTranslation('EVENT_NAME'),
		dataIndex : 'eventName',
		flex:1,
		renderer:function(value){
			if (!isNullOrEmpty(value)) {
				if(value == 'RESET_PASSWORD' || value == 'Reset Password'){
					return getMessagingModuleTranslation('RESET_PASSWORD');
				}else if(value == 'ADD_EXTERNAL_USER' || value == 'Add External User'){
					return getMessagingModuleTranslation('ADD_EXTERNAL_USER');
				}else if(value == 'APPLICANT_RESET_PASSWORD' || value == 'Applicant Reset Password'){
					return getMessagingModuleTranslation('APPLICANT_RESET_PASSWORD');
				}else if(value == 'CREATE_ENQUIRY' || value == 'Create Enquiry'){
					return getMessagingModuleTranslation('CREATE_ENQUIRY');
				}else if(value == 'MSG_CREATE_CAMPAIGN' || value == 'Msg Create Campaign'){
					return getMessagingModuleTranslation('MSG_CREATE_CAMPAIGN');
				}else if(value == 'SA_SAU_MAU_MAPPING' || value == 'Sa Sau Mau Mapping'){
					return getMessagingModuleTranslation('SA_SAU_MAU_MAPPING');
				}else if(value == 'ADD_ORG_STRUCTURE' || value == 'Add Org Structure'){
					return getMessagingModuleTranslation('ADD_ORG_STRUCTURE');
				}else if(value == 'SEND_OFFER_LETTER' || value == 'Send Offer Letter'){
					return getMessagingModuleTranslation('SEND_OFFER_LETTER');
				}else if(value == 'USER_PROGRAM_COURSE_ASSOCIATION' || value == 'User Program Course Association'){
					return getMessagingModuleTranslation('USER_PROGRAM_COURSE_ASSOCIATION');
				}else if(value == 'USER_ACADMEY_LOCATION_ASSOCIATION' || value == 'User Acadmey Location Association'){
					return getMessagingModuleTranslation('USER_ACADMEY_LOCATION_ASSOCIATION');
				}else if(value == 'UNLOCK_USER' || value == 'Unlock User'){
					return getMessagingModuleTranslation('UNLOCK_USER');
				}else if(value == 'EMPLOYEE_LEAVE_CREATE' || value == 'Employee Leave Create'){
					return getMessagingModuleTranslation('EMPLOYEE_LEAVE_CREATE');
				}else if(value == 'EMPLOYEE_LEAVE_REJECT' || value == 'Employee Leave Reject'){
					return getMessagingModuleTranslation('EMPLOYEE_LEAVE_REJECT');
				}else if(value == 'EMPLOYEE_LEAVE_WITHDRAWN' || value == 'Employee Leave Withdrawn'){
					return getMessagingModuleTranslation('EMPLOYEE_LEAVE_WITHDRAWN');
				}else if(value == 'EMPLOYEE_LEAVE_REQUESTER_APPROVE' || value == 'Employee Leave Requester Approve'){
					return getMessagingModuleTranslation('EMPLOYEE_LEAVE_REQUESTER_APPROVE');
				}else if(value == 'EMPLOYEE_LEAVE_APPROVER_APPROVE' || value == 'Employee Leave Requester Approve'){
					return getMessagingModuleTranslation('EMPLOYEE_LEAVE_APPROVER_APPROVE');
				}else if(value == 'EMPLOYEE_LEAVE_REQUEST_ESCALATION_REQUESTER' || value == 'Employee Leave Request Escalation Requester'){
					return getMessagingModuleTranslation('EMPLOYEE_LEAVE_REQUEST_ESCALATION_REQUESTER');
				}else if(value == 'EMPLOYEE_LEAVE_REQUEST_ESCALATION_APPROVER' || value == 'Employee Leave Request Escalation Approver'){
					return getMessagingModuleTranslation('EMPLOYEE_LEAVE_REQUEST_ESCALATION_APPROVER');
				}else if(value == 'STUDENT_HOSTEL_LEAVE_REJECT_REJECT' || value == 'Student Hostel Leave Reject'){
					return getMessagingModuleTranslation('STUDENT_HOSTEL_LEAVE_REJECT_REJECT');
				}else if(value == 'STUDENT_HOSTEL_LEAVE_APPROVE' || value == 'Student Hostel Leave Approve'){
					return getMessagingModuleTranslation('STUDENT_HOSTEL_LEAVE_APPROVE');
				}else{
					return value;
				} 
			}
		}
	},{
		header : getMessagingModuleTranslation('ATTACHED_DOCUMENT'),
		dataIndex : 'attachedDocument',
		flex : 1,
		renderer:function(value){
			if (!isNullOrEmpty(value) && value) {
				return  '<a href="#">'+getPersonModuleTranslation('MD_VIEW_DOCUMENT')+'</a>';
			}else{
				return  '-';
			}
		}
	}]
});