/**
 * @author Rajkumar.patidar
 * Template Panel with template quick search form & search result grid
 */
Ext.define('Academia.view.messaging.report.SendMessageReportStructure', {
	extend: 'Ext.form.Panel',
	alias: 'widget.sendmessagereportstructure',
	cls: 'panelNoSpace',
	autoScroll: true,
	plugins: "formlabelrequired",
	standardSubmit : false,
	items: [{
		xtype:'panel',
		items:[{
			xtype: 'form',
			cls:'customSearchPanel',			
			items:[{
				xtype : 'radiogroup',
				itemId:'sendmessageId',
				labelAlign : 'top',
				allowBlank: false,
				fieldLabel:getMessagingModuleTranslation('SENT_MESSAGES'),
				items : [{
					boxLabel : getMessagingModuleTranslation('EMAIL'),
					name:'sendMessage',
					inputValue : 1,
					checked : true
				},{
					boxLabel : getMessagingModuleTranslation('SMS'),
					name:'sendMessage',	
					inputValue : 2
				}]
			},{
				xtype: 'fieldcontainer',
				width: '100%',
				layout: 'hbox',
				defaults: {
					labelAlign: 'top',
					width: 256
				},
				items: [{
					xtype: 'customcombobox',
					name:'recipientName',
					itemId: 'recipientName',
					store:'messaging.SendMessageReportRecipientStore',
					fieldLabel: getMessagingModuleTranslation('RECIPIENT_NAME'),
					displayField: 'code',
					valueField: 'code',
					queryParam:'recipientName',
					minChars:3,
					typeAhead:false,
					hideTrigger:false,
					triggerCls: Ext.baseCSSPrefix + 'form-search-trigger',
					triggerAction: '',
					emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
					forceSelection:true,
					listConfig: {
						listeners: {
							beforeshow: function(picker) {
								picker.minWidth = picker.up('combobox').getSize().width;
								picker.width = picker.up('combobox').getSize().width;
							}
						},
						loadingText: getCommonTranslation('SEARCHING'),
						emptyText: getCommonTranslation('NO_RECORDS_FOUND')
					}
					/* // triggerAction: '',
			            forceSelection:true,
			            triggerCls : Ext.baseCSSPrefix + 'x-form-trigger',
			            enableKeyEvents  : 'true',*/
				},{
					xtype: 'customcombobox',
					name:'contactId',
					itemId: 'contactId',
					store: Ext.create('Academia.store.messaging.SendMessageReportContactStore'),
					fieldLabel: getMessagingModuleTranslation('EMAIL'),
					displayField: 'code',
					valueField: 'code',
					queryParam:'contactId',
					minChars:3,
					typeAhead:true,
					hideTrigger:false,
					triggerCls: Ext.baseCSSPrefix + 'form-search-trigger',
					triggerAction: '',
					emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
					forceSelection:true,
					listConfig: {
						listeners: {
							beforeshow: function(picker) {
								picker.minWidth = picker.up('combobox').getSize().width;
								picker.width = picker.up('combobox').getSize().width;
							}
						},
						loadingText: getCommonTranslation('SEARCHING'),
						emptyText: getCommonTranslation('NO_RECORDS_FOUND')
					},
					/* // triggerAction: '',
			            forceSelection:true,
			            triggerCls : Ext.baseCSSPrefix + 'x-form-trigger',
			            enableKeyEvents  : 'true',*/
				},{
					xtype: 'customcombobox',
					name:'mobileId',
					itemId: 'mobileId',
					store: Ext.create('Academia.store.messaging.SendMessageReportContactStore'),
					fieldLabel: getMessagingModuleTranslation('MOBILE_NO'),
					displayField: 'code',
					valueField: 'code',
					vtype:'numericValueValidation',
					queryParam:'contactId',
					minChars:3,
					typeAhead:false,
					hideTrigger:false,
					triggerCls: Ext.baseCSSPrefix + 'form-search-trigger',
					triggerAction: '',
					hidden:true,
					emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
					forceSelection:true,
					listConfig: {
						listeners: {
							beforeshow: function(picker) {
								picker.minWidth = picker.up('combobox').getSize().width;
								picker.width = picker.up('combobox').getSize().width;
							}
						},
						loadingText: getCommonTranslation('SEARCHING'),
						emptyText: getCommonTranslation('NO_RECORDS_FOUND')
					},
					listeners: {
						change: function(obj, record) {
							
							if(!isNullOrEmpty(record)){
								if(isNaN(record)){
									if(record.indexOf('%') == -1){
										obj.setValue(record.slice(0, record.length-1));	
									}
								}
							}
							
							/*if(!(/^[0-9]*$/.test(record))){
								if(record!=null){
									obj.setValue(record.slice(0, record.length-1));
								}	    							
							}*/
						}
					}
				/* // triggerAction: '',
			            forceSelection:true,
			            triggerCls : Ext.baseCSSPrefix + 'x-form-trigger',
			            enableKeyEvents  : 'true',*/
				},{
					xtype: 'customcombobox',
					name:'sentby',
					itemId: 'sentby',
					store:'criteriabuilder.userquicksearch.QuickSearchPrintNameStore',
					fieldLabel: getMessagingModuleTranslation('SENT_BY'),
					displayField: 'valueCode',
					valueField: 'id',
					queryParam:'printName',
					minChars:3,
					typeAhead:false,
					hideTrigger:false,
					triggerCls: Ext.baseCSSPrefix + 'form-search-trigger',
					triggerAction: '',
					emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
					forceSelection:true,
					listConfig: {
						listeners: {
							beforeshow: function(picker) {
								picker.minWidth = picker.up('combobox').getSize().width;
								picker.width = picker.up('combobox').getSize().width;
							}
						},
						loadingText: getCommonTranslation('SEARCHING'),
						emptyText: getCommonTranslation('NO_RECORDS_FOUND')
					}
				
				}]},{
					xtype: 'fieldcontainer',
					width: '100%',
					layout: 'hbox',
					defaults: {
						labelAlign: 'top',
						width: 256
					},
					items: [{
						xtype: 'customcombobox',
						name:'eventName',
						itemId: 'eventName',
						store:'messaging.SendMessageReportEventNameStore',
						fieldLabel: getMessagingModuleTranslation('EVENT_NAME'),
						displayField: 'uiDisplayCode',
						valueField: 'uiDisplayCode',
						queryParam:'eventName',
						minChars:3,
						typeAhead:false,
						//hideTrigger:true,
						emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
						/* // triggerAction: '',
			            forceSelection:true,
			            triggerCls : Ext.baseCSSPrefix + 'x-form-trigger',
			            enableKeyEvents  : 'true',*/
						 forceSelection:true,
						 listConfig: {
							 listeners: {
								 beforeshow: function(picker) {
									 picker.minWidth = picker.up('combobox').getSize().width;
								 }
							 },
							 loadingText: getCommonTranslation('SEARCHING'),
							 emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
							 getInnerTpl: function() {
								 return '<div class="search-item">' +
								 '{code}'+ 
								 '</div>';
							 }
						 }
					},{
						xtype: 'datefield',
						name: 'eventDateForm',
						itemId:'eventDateForm',
						listeners: {
							render: function(field) {
								return dateFormatRender(field);
							}
						},
						//--submitFormat: CONSTANTS.DATE_FORMAT,
						vtype: 'daterange',
						endDateField: 'eventDateTill',
						editable:false,
						fieldLabel: getFeeAndPaymentCommonTranslation('START_DATE'),
						allowBlank:false

					},{
						xtype: 'datefield',
						name: 'eventDateTill',
						itemId:'eventDateTill',
						listeners: {
							render: function(field) {
								return dateFormatRender(field);
							}
						},
						//--submitFormat: CONSTANTS.DATE_FORMAT,
						vtype: 'daterange',
						startDateField: 'eventDateForm',
						editable:false,
						fieldLabel: getFeeAndPaymentCommonTranslation('END_DATE'),
						allowBlank:false
					}, {
			            xtype: 'customcombobox',
			            fieldLabel: getMessagingModuleTranslation('STATUS'),            
			            store: 'messaging.SendMessageReportStatusStore',
			            editable: false,
			            name: 'status',
			            itemId: 'statusComboMsgSendReport',            
			            valueField: 'name',
			            queryMode: 'local',
			            displayField: 'value'
			        }]
				},{
					xtype: 'fieldset',
					itemId:'fieldsetId',
					collapsible : true,
					collapsed: true,
					title: getCommonTranslation('MORE_DETAILS'),
					titleCollapse: true,
					defaults : {
						labelAlign:'top',
//						tdAttrs: { style: 'padding: 5px;' }
					},
					style: {
			          	 marginTop: '33px!important'
			         },
					items:[{
				        xtype: 'fieldcontainer',
				        layout: 'hbox',
				        defaults: {
				            labelAlign: 'top',
				            width: 256
				        },
				        items: [{

				        	xtype: 'customcombobox',
				        	fieldLabel: getAdmissionTranslation('ACADEMY_LOCATION'),
				        	name: 'academyLocationId',
				        	itemId:'academyLocationId',
				        	store: 'user.UserAcademyLocationStore',
				        	displayField: 'value',
				        	valueField: 'id',
				        	width:685,
				        	minChars:3,
				        	queryParam:'qry',
				        	forceSelection:true,
				        	emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
				        	listConfig: {
				        		listeners: {
				        			beforeshow: function(picker) {
				        				picker.minWidth = picker.up('combobox').getSize().width;
				        			}
				        		},
				        		loadingText: getCommonTranslation('SEARCHING'),
				        		emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
				        	}
				        }]
			    },{
			        xtype: 'fieldcontainer',
			        layout: 'hbox',
			        defaults: {
			            labelAlign: 'top',
			            width: 256
			        },
			        items: [{
		                xtype: 'customcombobox',
		                name: 'intakeYearPlcDriveId',
		                itemId: 'intakeYearPlcDriveId',
		                fieldLabel: getCommonTranslation('INTAKE_YEAR'),
		                store: Ext.create('Academia.store.common.IntakeYearStore'),
		                valueField: 'id',
		                displayField: 'value',
		                forceSelection: true,
		    		},{
		        		xtype: 'customcombobox',
		        		name: ' programGroup',
		        		itemId:'Program_Group',
		        		fieldLabel: getCommonTranslation('PROGRAM_GROUP'),
		        		store:'personinfo.common.personalinfo.AttendanceReportProgramGroupStore',
		        		valueField: 'id',
		        		displayField: 'value',
		        		forceSelection:true,
		        	}]
			    },{
			        xtype: 'fieldcontainer',
			        layout: 'hbox',
			        defaults: {
			            labelAlign: 'top',
			            width: 256
			        },
			        items: [{
			            xtype: 'customcombobox',
						fieldLabel: getAdmissionTranslation('PROGRAM'),
			            name: 'programId',
			            itemId:'programId',
			            store : Ext.create('Academia.store.attendance.AttendanceProgramSectionStore'),
			            displayField: 'value',
			            valueField: 'id',
			            forceSelection:true,
			        },{
						 xtype: 'customcombobox',
						 name: 'batchId',
						 itemId:'batchId',
						 fieldLabel: getCommonTranslation('BATCH'),
						 store : Ext.create('Academia.store.program.programbatchdetail.BatchByProgramIdSSStore'),
						 valueField: 'id',
						 displayField: 'value',
						 disabled:true,
						 forceSelection:true,
						/* listeners: {
								render: function(combo) {
									var store = Ext.create('Academia.store.program.programbatchdetail.BatchByProgramIdSSStore');
									combo.bindStore(store);
								}
							}*/
					 	},{
				            xtype: 'customcombobox',
							fieldLabel: getCommonTranslation('PERIOD'),
							store : Ext.create('Academia.store.program.programbatchdetail.PeriodByBatchIdSSStore'),
				            name: 'periodId',
				            itemId:'periodId',
				            displayField: 'value',
				            valueField: 'id',
				            disabled:true,
				            forceSelection:true,
				            /*listeners: {
				            	render: function(combo) {
				            		var store = Ext.create('Academia.store.program.programbatchdetail.PeriodByBatchIdSSStore');
				            		combo.bindStore(store);
				            	}
				            }*/
				        },{
							 xtype: 'customcombobox',
								 fieldLabel: getCommonTranslation('SECTION'),
								 store : Ext.create('Academia.store.program.programbatchdetail.SectionByPeriodIDSmartSearch'),
								 valueField: 'sectionId',
								 displayField: 'sectionCode',
								 name: 'sectionId',
								 itemId:'sectionId',
								 disabled:true,
								 forceSelection:true,
								/* listeners: {
						            	render: function(combo) {
						            		var store = Ext.create('Academia.store.program.programbatchdetail.SectionByPeriodIDSmartSearch');
						            		combo.bindStore(store);
						            	}
						            }*/
							 	}]
			    },{
			    	xtype: 'fieldcontainer',
			    	layout: 'hbox',
			    	defaults: {
			    		labelAlign: 'top',
			    		width: 256
			    	},
			    	items: [{
			    		xtype: 'customcombobox',
			    		name: 'STUDENT_ID',
			    		itemId:'studentId',
			    		fieldLabel: getFeeAndPaymentCommonTranslation('STUDENT_CODE_NAME'),
			    		store: 'messaging.StudentsFilterByAcademyLocationIdStore',
			    		valueField: 'id',
			    		displayField: 'valueCode',
			    		width: 536,
			    		forceSelection:true,
			    	}]
			    }]
			         },{
					xtype: 'fieldcontainer',
					width: '100%',
		    		layout : {
		    			type : 'hbox'
		    		},
		    		cls: 'customSearchPanelBtnsFieldContainerCls',
					items: [{
						xtype: 'button',
						text: getMessagingModuleTranslation('SEARCH'),
						itemId: 'searchButtonId',
						//buttonAlign: 'right',
						ui: 'CustomBtnSubmit',
						formBind : true,
						scale: CONSTANTS.BUTTONSIZE						
					}, {
						xtype: 'button',
						text: getMessagingModuleTranslation('CLEAR_SEARCH'),
						itemId: 'resetButtonId',
						//buttonAlign: 'right',
						hidden:false,
						ui: 'CustomBtnCancel',
						scale: CONSTANTS.BUTTONSIZE
					}]
				}]
		}, {
			xtype: 'sendmessagelist',
			itemId: 'sendmessagelistItemId',
		}]
	}]
});