Ext.define('Academia.view.organization.academies.AcademiesStructureGrid', {
	extend: 'Academia.view.facilitiesresources.resourcebooking.StaticGridExcelExport',
    alias: 'widget.academiesStructureGrid',
    store: 'organization.AcademiesStructureStore',
    title: getCommonTranslation('LIST_OF_ACADEMIES'),
    border: true,
    viewConfig: {
        stripeRows: CONSTANTS.STRIPEROWS
    },
    headerFix:{
		headerFix: true,
		portalIdsWithStructure: {
			'academiesStructure':1
		}
	},
    dockedItems: [{
        xtype: 'toolbar',
        dock: 'bottom',
        items: [{
            xtype: 'custompagingtoolbar',
            plugins:['pagesize'],
            store: 'organization.AcademiesStructureStore',
            emptyMsg: getCommonTranslation('EMPTY_MESSAGE'),
            displayInfo: true
        }]
    }],
    initComponent: function() {

        var grid=this;                   

        grid.addExportToolBarItems(grid);

        this.callParent(arguments);     

 },
    tbar: [{
        xtype: 'button',
        itemId: 'btnAdd',
        tooltip: getCommonTranslation('ADD'),
        glyph: ICONGLYPH.ADDGLYPH
    }, {
        xtype: 'button',
        itemId: 'btnEdit',
        tooltip: getCommonTranslation('EDIT'),
        glyph: ICONGLYPH.EDITGLYPH
    }, {
        xtype: 'button',
        itemId: 'btnView',
        tooltip: getCommonTranslation('VIEW'),
        iconCls: 'view-icon'
    }, {
        xtype: 'button',
        itemId: 'btnDelete',
        cls: 'CustomToolbarBtnReject',
        tooltip: getCommonTranslation('DELETE'),
        glyph: ICONGLYPH.DELETEGLYPH
    }],
    columns: [{
        header: getCommonTranslation('ACADEMY_CODE'),
        dataIndex: 'academyCode',
        sortable:true,
        flex: .12
    }, {
        header: getCommonTranslation('ACADEMY_NAME'),
        dataIndex: 'academyName',
        sortable: true,
        flex: .3
    }, {
        header: getCommonTranslation('ACADEMY_AFRIKAANS'),
        dataIndex: 'academyAfrikaans', 
        sortable: true,
        flex: .3
    }, {
        header: getCommonTranslation('ACADEMY_TYPE'),
        dataIndex: 'academyType',
        sortable:true,
        flex: .1,
        renderer:function(value,meta,record){
        	if(!isNullOrEmpty(value)) {
				return getCommonTranslation(value);
			} else {
				return "-";
			}                     
        }
    }, {
        header: getCommonTranslation('START_DATE'),
        dataIndex: 'startDate',
        sortable:true,
        flex: .2,
        renderer: function(date) {
            return dateRender(date);
        }
    }, {
        header: getCommonTranslation('END_DATE'),
        dataIndex: 'tillDate',
        sortable:true,
        type: 'Date',
        flex: .2,
        renderer: function(date) {
            return dateRender(date);
        }
    }, {
        header: getCommonTranslation('STATUS'),
        dataIndex: 'status',
        sortable:true,
        flex: .1,
        renderer: function(value) {
            return statusRender(value);
        }
    }]

});