Ext.define('Academia.view.organization.managementaccounting.MAUTreeFormWindow', {
    extend: 'Ext.window.Window',
    alias: 'widget.mauTreeFormWindow',
    modal: true,
    autoScroll: true,
    title: getCommonTranslation('MANAGEMENTACCPOPUPTITLE'),
    plugins : 'formlabelrequired',
    items: [{
        xtype: 'form',
        autoScroll: true,
        defaultType: 'textfield',
        defaults: {
            width: 256,
            labelAlign: 'top'
        },
        items: [{
            xtype: 'hidden',
            name: 'parentId',
            itemId: 'parentItemId'
        }, {
            xtype: 'hidden',
            name: 'organizationSupervisoryUnit'
        }, {
            xtype: 'hidden',
            name: 'id'
	    }, {
	        xtype: 'hidden',
	        name: 'version'
	    }, {
            xtype: 'hidden',
            name: 'parentOrganizationUnitId',
            itemId: 'parentOrganizationHiddenId'
        }, {
	        xtype: 'fieldcontainer',
	        width: 'auto',
	        layout: {
	            type: 'hbox'
	        },
	        defaults: {
	            labelAlign: 'top',
	            width: 256
	        },
	        items: [{
	        	xtype: 'textfield',
	            fieldLabel: getCommonTranslation('SHORTCODE'),
	            name: 'shortCode',
	            allowBlank: false
	        }, {
	        	xtype: 'textfield',
	            fieldLabel: getCommonTranslation('IAUNAME'),
	            name: 'unitName',
	            allowBlank: false
	        }]

        },{
        	xtype: 'fieldcontainer',
        	width: 'auto',
        	layout: {
        		type: 'hbox'
        	},
        	defaults: {
        		labelAlign: 'top',
        		width: 256
        	},
        	items: [{
        		xtype: 'textfield',
        		fieldLabel: getCommonTranslation('PARENTIAU'),
        		readOnly: true,
        		name: 'parentOrganizationUnit',
        		itemId: 'parentISU'
        	}, {
        		xtype: 'nestedJsonCombo',
//      		queryMode:'local',
        		fieldLabel: getCommonTranslation('IAUOWNER'),
        		name: 'owner',
        		store: 'common.UsersComboStore',
        		displayField: 'valueCode',
        		valueField: 'id',
        		itemId: 'ownerId',
        		editable: false,
        		allowBlank: false
        	}] 
        }, {
            xtype: 'fieldcontainer',
            width: 'auto',
            layout: {
                type: 'hbox'
            },
            defaults: {
                labelAlign: 'top',
                width: 256
            },
            items: [{
                xtype: 'datefield',
                name: 'startDate',
                itemId: 'startDate',
                vtype: 'daterange',
                endDateField: 'tillDate',
                allowBlank: false,
                editable: false,
                listeners: {
                	render: function(field) {
                		return dateFormatRender(field);
                	}
                },
              //--submitFormat: CONSTANTS.DATE_FORMAT,
                fieldLabel: getCommonTranslation('IAUSTARTDATE')
            }, {
                xtype: 'datefield',
                name: 'tillDate',
                itemId: 'tillDate',
                vtype: 'daterange',
                startDateField: 'startDate',
                editable: false,
                listeners: {
                	render: function(field) {
                		return dateFormatRender(field);
                	}
                },
              //--submitFormat: CONSTANTS.DATE_FORMAT,
                fieldLabel: getCommonTranslation('IAUTILLDATE')
            }]

        }, {
            xtype: 'fieldcontainer',
            width: 'auto',
            layout: {
                type: 'hbox'
            },
            defaults: {
                labelAlign: 'top',
                width: 256
            },
            items: [{
                xtype: 'nestedJsonCombo',
                queryMode:'local',
                itemId: 'currencyCombo',
                store: 'organization.BaseCurrencyStore',
                fieldLabel: getCommonTranslation('CURRENCY'),
                displayField: 'name',
                valueField: 'id',
                lableAlign: 'top',
                width: 256,
                allowBlank: false,
                editable: false,
                name: 'currencyId'
            }, {
                xtype: 'statusCombo',
                fieldLabel: getCommonTranslation('STATUS'),
                name: 'status',
                editable: false,
                allowBlank: false
            }]

        }, {
            xtype: 'fieldcontainer',
            width: '100%',
            
            items: [{
                xtype: 'button',
                text: getCommonTranslation('SUBMIT'),
                itemId: 'formSubmitButtonId',
                action: 'Submit',
                formBind: true,
                ui: 'CustomBtnSubmit',
                scale: CONSTANTS.BUTTONSIZE
            }, {
                xtype: 'button',
                text: getCommonTranslation('CANCEL'),
                action: 'Cancel',
                ui: 'CustomBtnCancel',
                scale: CONSTANTS.BUTTONSIZE
            }]
        }]
    }]
});