Ext.define('Academia.view.organization.sasaumaumapping.AllocatedALPToOthersGrid', {
    extend: 'Ext.grid.Panel',
    alias: 'widget.allocatedalptoothersgrid',
    title: getCommonTranslation('ALLOCATED_ALP_GRID_TO_OTHERS_TITLE'),
    store: 'organization.susaumapping.AllocatedALPToOthersStore',
    hidden: true,
    flex: 1,
    viewConfig: {
        stripeRows: CONSTANTS.STRIPEROWS
    },
    columns: [/*{
        header: 'id',
        dataIndex: 'id',
        hidden: true
    },*/ /*{
        dataIndex: 'organizationSupervisoryUnitId',
        hidden: true
    }, {
        dataIndex: 'organizationUnitId',
        hidden: true
    },*/ {
        header: getCommonTranslation('ACADEMY'),
        dataIndex: 'academy.academyName',
        flex: 0.2
    }, {
        header: getCommonTranslation('LOCATION'),
        dataIndex: 'location.name',
        flex: 0.2
    }, {
        header: getCommonTranslation('PURPOSE'),
        dataIndex: 'purpose',
        flex: 0.2
    }, {
        header: getCommonTranslation('START_DATE'),
        dataIndex: 'startDate',
        xtype: 'datecolumn',
        dateFormat: 'd-m-Y',
        flex: 0.1,
		renderer:function(date) {
			return dateRender(date);
		}
    }, {
        header: getCommonTranslation('END_DATE'),
        dataIndex: 'tillDate',
        xtype: 'datecolumn',
        dateFormat: 'd-m-Y',
        flex: 0.1,
		renderer:function(date) {
			return dateRender(date);
		}
    }, {
        xtype: 'actioncolumn',
        header: getCommonTranslation('UNLINK'),
        icon: 'resources/images/unlink2.png',
        tooltip: getCommonTranslation('UNLINK'),
        itemId: 'allocatedALPToOthersGridActionColumnId',
        flex: 0.2
    }],
    dockedItems : [ {
    	xtype : 'toolbar',
    	dock : 'bottom',
    	items : [ {
    		xtype: 'custompagingtoolbar',
            plugins:['pagesize'],
	        displayInfo: true,
	        store: 'organization.susaumapping.AllocatedALPToOthersStore'
    	 }]
    }]

});