Ext.define('Academia.view.organization.sasaumaumapping.SU-SAU-MAUStructure', {
	extend: 'Ext.panel.Panel',
	alias: 'widget.alpgroupmapping',
	autoScroll:true,
	frame:true,
	cls: 'panelNoSpace',
	title: getCommonTranslation('SU_SAU_MAU_TITLE'), //SU-SAU-MAU
	items: [{
		xtype: 'panel',
		frame: false,
		layout: 'vbox',
		padding: 32,
		items: [{
				xtype:'panel',
				layout:'hbox',
				height: 80,
				width: '100%',
				items: [{
					xtype: 'combo',
					fieldLabel: getCommonTranslation('SU_SAU_MAU_ORGANIZATION_GROUP'),
					name: 'organizationGroup',
					itemId: 'organizationGroupId',
					width: 300,
					labelAlign: "top",
					emptyText: getCommonTranslation('PLEASE_SELECT_RECORD'),
					store: 'organization.susaumapping.OrganizationGroupStore',
					valueField: 'id',
					editable: false,
					tpl: Ext.create('Ext.XTemplate',
							'<tpl for=".">',
							'<div class="x-boundlist-item">{structureTypeCode} - {unitName}</div>',
							'</tpl>'
					),
					displayTpl: Ext.create('Ext.XTemplate',
							'<tpl for=".">',
							'{structureTypeCode} - {unitName}',
							'</tpl>'
					)
				}]
			},
			{
				xtype:'panel',
				flex: 1,
				width: '100%',                     // take remaining space
				layout:'hbox',
				style:{
					'padding': '0px !important;'
				},
				items: [
					{
						xtype: 'organizationgrouptreestructure',
						width: 300
					},
					{
						xtype: 'panel',
						flex: 1,
						border: true,
						autoScroll: true,
						layout: {
							type: 'vbox',
							align: 'stretch'
						},
						style:{
							'padding': '0px !important;',
							'border-top': '1px solid var(--border-color-disabled) !important;'
						},
						defaults: {
							flex: 1,
							border: true,
							autoScroll: true
						},
						cls: 'panelNoSpace',
						items: [
							{ 
								xtype: 'allocatedalptoothersgrid',
								style:{
									'left': '0px !important;',
									'margin-left': '32px !important;'
								}
							},
							{ 
								xtype: 'allocatedalpgrid',
								style:{
									'left': '0px !important;',
									'margin-left': '32px !important;'
								}
							},
							{ 
								xtype: 'unallocatedalpgrid',
								style:{
									'left': '0px !important;',
									'margin-left': '32px !important;'
								}
							}
							]
					}
					]
			}]
	}]
});