/*
 * View of the statutory accounting which contains the Form for adding and editing.
 * @Author Akshay.Kalbhor
 *
 */

Ext.define('Academia.view.organization.statutoryAccounting.StatutoryAccountingForm', {
    extend: 'Ext.window.Window',
   /* requires : ['Academia.view.common.CustomCombo' ], */
    alias: 'widget.stataccformwindow',
    autoScroll: true,
    modal : true,
    title: getCommonTranslation('STATACCTITLE'),
    frame: true,
    plugins : 'formlabelrequired',
    items: [{
	xtype: 'form',
	defaultType: 'textfield',
	standardSubmit: false,
	defaults: {
	       width: 256
	},
	items: [{
	    xtype: 'hidden',
	    name: 'organizationSupervisoryUnit'
	},{
	        xtype: 'hidden',
	        name: 'parentId',
	        itemId: 'parentItemId'
	    }, {
	        xtype: 'hidden',
	        name: 'id'
	    }, {
	        xtype: 'hidden',
	        name: 'version'
	    }, {
	        xtype: 'hidden',
	        name: 'parentOrganizationUnitId',
	        itemId: 'parentOrganizationHiddenId'
	    },{
	        xtype: 'fieldcontainer',
	        width: 'auto',
	        layout: {
	            type: 'hbox'
	        },
	        defaults: {
	            lableAlign: 'top',
	            width: 256
	        },
	        items: [{
	        	xtype:'textfield',
		        fieldLabel: getCommonTranslation('SASHORTCODE'),
		        labelAlign: 'top',
		        name: 'shortCode',
		        allowBlank: false,
		        enforceMaxLength:true,
	            maxLength:15
		    }, {
		        fieldLabel: getCommonTranslation('SAIAUNAME'),
		        labelAlign: 'top',
		        name: 'unitName',
		        xtype:'textfield',
		        allowBlank: false
		    }]

	    },{
	        xtype: 'fieldcontainer',
	        width: 'auto',
	        layout: {
	            type: 'hbox'
	        },
	        defaults: {
	            lableAlign: 'top',
	            width: 256
	        },
	        items: [{
	        	xtype:'textfield',
		        fieldLabel: getCommonTranslation('SAPARENTIAU'),
		        labelAlign: 'top',
		        readOnly: true,
		        name: 'parentOrganizationUnit',
		        itemId: 'parentISU'
		    },{
	            xtype: 'livesearchcombo',
	            name: 'owner',
	            labelAlign: 'top',
	            fieldLabel: getCommonTranslation('SAIAUOWNER'),
	            itemId: 'ownerId',
		        allowBlank: false,
	        	emptyText: getCommonTranslation('ENTER_THREE_CHAR')
	        }]

	    },  {
	        xtype: 'fieldcontainer',
	        width: 'auto',
	        layout: {
	            type: 'hbox'
	        },
	        defaults: {
	            lableAlign: 'top',
	            width: 256
	        },
	        items: [{
	            xtype: 'datefield',
	            name: 'startDate',
	            listeners: {
	            	render: function(field) {
	            		return dateFormatRender(field);
	            	}
	            },
	          //--submitFormat: CONSTANTS.DATE_FORMAT,
	            fieldLabel: getCommonTranslation('SAIAUSTARTDATE'),
	            labelAlign: 'top',
	            vtype: 'daterange',
	            itemId: 'startDate',
	            endDateField:'tillDate',
	            editable: false,
	            allowBlank: false
	        }, {
	            xtype: 'datefield',
	            fieldLabel: getCommonTranslation('SAIAUTILLDATE'),
	            labelAlign: 'top',
	            name: 'tillDate',
	            itemId:'tillDate',
	            vtype: 'daterange',
	            editable: false,
	            startDateField: 'startDate',
	            listeners: {
	            	render: function(field) {
	            		return dateFormatRender(field);
	            	}
	            },
	          //--submitFormat: CONSTANTS.DATE_FORMAT
	        }]

	    }, {
	        xtype: 'fieldcontainer',
	        width: 'auto',
	        layout: {
	            type: 'hbox'
	        },
	        defaults: {
	            lableAlign: 'top',
	            width: 256
	        },
	        items: [{
	            xtype: 'customcombobox',
	            store: 'feeandpayment.FeeCurrencyStore',
	            itemId: 'currencyCombo',
	            queryMode: 'local',
	            fieldLabel: getCommonTranslation('CURRENCY'),
	            displayField: 'name',
	            valueField: 'id',
	            labelAlign: 'top',
	            name: 'currencyId',
	            editable: false,
	            allowBlank: false
	        }, {
	            xtype: 'statusCombo',
	            fieldLabel: getCommonTranslation('STATUS'),
	            name: 'status',
	            editable: false,
	            allowBlank: false
	        }]

	    }, {
		xtype: 'fieldcontainer',
		width: '100%',
		cls:'windowBtnPos',
		items: [{
		        xtype: 'button',
		        text: getCommonTranslation('SAVE'),
		        action: 'submit',
		        formBind: true,
		        action: 'Submit',
		        ui: 'CustomBtnSubmit',
		        scale: CONSTANTS.BUTTONSIZE,
		        itemId: 'statAccSaveButton'
		        
		    }, {
		        xtype: 'button',
		        text: getCommonTranslation('CANCEL'),
		        action: 'Cancel',
		        ui: 'CustomBtnCancel',
		        scale: CONSTANTS.BUTTONSIZE,
		        itemId: 'statAccCancelButton'
		    }]
	    }]
    }]
});

