/**
 * @author trupti.paoneker
 * 
 * This component is used for to show window with new certificate master details. 
 */
Ext.define('Academia.view.othermasters.certificatemaster.CertificateMasterFormWindow', {
    extend: 'Ext.window.Window',
    alias: 'widget.certificatemasterformwindow',
    modal: true,
    //resizable: false,
    title: getCommonTranslation('CERTIFICATE_MASTER_DETAILS'), //certificate master Details	
    //margin: 0,
    items: [{
        xtype: 'form',
        itemId: 'certificateMasterForm',
        plugins: "formlabelrequired",
        standardSubmit: false,
        items: [{
            xtype: 'hidden',
            itemId: 'certificateMaster_hidden_field',
            name: 'id'
        }, {
            xtype: 'hidden',
            name: 'version'
        }, {
            xtype: 'fieldcontainer',
            width: 'auto',
            defaults: {
				width: 256,
				labelAlign: 'top'
			},
            layout: {
                type: 'hbox'
            },
            items: [{
                fieldLabel: getCommonTranslation('CERTIFICATE_CODE'),
                xtype: 'textfield',
                itemId: 'certificateCode',
                name: 'code',
                labelAlign: 'top',
                allowBlank: false
            },{
                fieldLabel: getCommonTranslation('CERTIFICATE_NAME'),
                xtype: 'textfield',
                itemId: 'certificateName',
                name: 'name',
                labelAlign: 'top',
                allowBlank: false,
                maxLength:100
            }]
        }, {
            xtype: 'fieldcontainer',
            width: 'auto',
            defaults: {
				width: 256,
				labelAlign: 'top'
			},
            layout: {
                type: 'hbox'
            },
            items: [/*{
                fieldLabel: getCommonTranslation('WHETHER_APPLICABLE_FACULTY'),
                xtype: 'checkboxfield',
                itemId: 'isAppliableForFaculty',
                name: 'whetherApplicableToFaculty',
                inputValue: true,
                uncheckedValue:false
            }*/{
            	xtype: 'customcombobox',
                name: 'certificateApplicableTo',
                itemId : 'certificateApplicableTo',
                fieldLabel: getCommonTranslation('CERTIFICATE_APPLICABLE_TO'),
                store: 'othermasters.certificatemaster.CertificateApplicableToStore',
                valueField: 'name',
                displayField: 'value',
                editable: false,
                labelAlign: 'top',
                allowBlank: false
            }, /*{
	        	xtype: 'multiselectcombofield',
	        	fieldLabel: getCommonTranslation('ROLE'),
	        	name: 'accountingYear',
	        	itemId: 'accountingYear',
	        	store: Ext.create('Academia.store.securitysetup.ActiveRolesStore'),
	        	valueField: 'id',
	        	displayField: 'Value',
	        	queryParam:'qry',
				minChars:3,
				typeAhead:true,
				triggerCls : Ext.baseCSSPrefix + 'x-form-trigger',
				enableKeyEvents  : 'true',
				hideTrigger:false,
				emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
				listConfig: {
					listeners: {
						beforeshow: function(picker) {
							picker.minWidth = picker.up('combobox').getSize().width;
						},
						afterRender: function(combo){
							combo.getStore().on("load", function(store, items){
								if(items.length==0)
									Ext.select('.x-boundlist-item').elements[0].hidden = true;
								else
									Ext.select('.x-boundlist-item').elements[0].hidden = false;
					        });
						}
					},
					loadingText: getCommonTranslation('SEARCHING'),
					emptyText: getCommonTranslation('NO_RECORDS_FOUND')
					getInnerTpl: function() {
						return '<div class="search-item">' +
						'{code}' +
						'</div>';
					}
				}
	        }*/ {

                xtype: 'multiselectcombofield',
                name: 'roles',
                itemId: 'roleIdsItemId',
                fieldLabel: getCommonTranslation('ROLE'),
                valueField: 'id',
    		    displayField: 'value',
    			store: Ext.create('Academia.store.securitysetup.ActiveRolesStore'),
    			labelAlign : 'top',
    			minChars:3,
    			typeAhead:false,
//    			cls:'multiBrandCampusCls',
    			grow: true,
                maxLength: 100000,
    			forceSelection:true,
    			autoloadStore: false,
//    			emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
    			listConfig: {
    				listeners: {
    					beforeshow: function(picker) {
    						picker.minWidth = picker.up('combobox').getSize().width;
    					},
    				},
    				loadingText: getCommonTranslation('SEARCHING'),
    				emptyText: getCommonTranslation('NO_RECORDS_FOUND')
    			
    			}
    		
            }]
        }, {
            xtype: 'fieldcontainer',
            width: 'auto',
            layout: 'hbox',
            defaults: {
				width: 256,
				labelAlign: 'top'
			},
           /* defaults: {
                labelWidth: 170
            },*/
            items: [{
                xtype: 'customcombobox',
                name: 'certificateCategory',
                itemId : 'certificateCategoryId',
                fieldLabel: getCommonTranslation('CERTIFICATE_TYPE'),
                store: 'othermasters.certificatemaster.CertificateTypeComboStore',
                valueField: 'name',
                displayField: 'value',
                editable: false,
                labelAlign: 'top',
                queryMode: 'local',
                allowBlank: false
            },{
            	xtype: 'customcombobox',
                name: 'dynamicDocumentTypeId',
                itemId : 'dynamicDocTypeId',
                fieldLabel: getCommonTranslation('DYNAMIC_DOCUMENT_TYPE'),
                store: 'othermasters.certificatemaster.DynamicDocumentTypes',
                valueField: 'documentTypeId',
                displayField: 'typeName',
                editable: false,
                labelAlign: 'top',
                queryMode: 'local',
                allowBlank: false
            }]
        }, {
            xtype: 'fieldcontainer',
            width: 'auto',
            layout: {
                type: 'hbox'
            },

            items: [{
                boxLabel: getCommonTranslation('STATUS'),
                xtype: 'checkboxfield',
                itemId: 'isActive',
                name: 'isActive',
                width: 256,
                inputValue: 'true',
                uncheckedValue: 'false'

            },
            {
                boxLabel: getCommonTranslation('IS_SEQUENCE_REQUIRED'),
                xtype: 'checkboxfield',
                itemId: 'isSequenceRequired',
                name: 'isSequenceRequired',
                width: 256,
                inputValue: 'true',
                uncheckedValue: 'false'

            }]
        }, {
            xtype: 'fieldcontainer',
            width: '100%',            
            items: [{
                xtype: 'button',
                itemId: 'btnSaveCertificateMasterForm',
                text: getCommonTranslation('SAVE'), //Submit
                ui: 'CustomBtnSubmit',
                scale: CONSTANTS.BUTTONSIZE,
                formBind: true
            }, {
                xtype: 'button',
                itemId: 'btnCancelCertificateMasterForm',
                text: getCommonTranslation('CANCEL'), //Cancel
                ui: 'CustomBtnCancel',
                scale: CONSTANTS.BUTTONSIZE
            }]
        }]

    }]
});