/**
 * @author Amit G
 * 
 * This component is used for to show window with new currency master details. 
 */
Ext.define('Academia.view.othermasters.currencymaster.CurrencyMasterFormSetUpWindow', {
    extend: 'Ext.window.Window',
    alias: 'widget.currencymasterformsetupwindow',
    modal: true,
    resizable: false,
    title: getCommonTranslation('CURRENCY_MASTER_DETAILS'), //Currency Details	
    items: [{
        xtype: 'form',
        itemId: 'currencyMasterSetupForm',
        plugins: "formlabelrequired",
        standardSubmit: false,
        items: [{
            xtype: 'hidden',
            itemId: 'currencyFormSetupHiddenId',
            name: 'id'
        }, {
            xtype: 'hidden',
            name: 'version'
        }, {
            xtype: 'fieldcontainer',
            layout: 'hbox',
            defaults: {
                labelAlign: 'top',
                width: 256
            },
            items: [{
            	xtype: 'customcombobox',
                name: 'name',
                itemId : 'name',
                fieldLabel: getCommonTranslation('CURRENCY_NAME'), //Currency Name
                store: 'othermasters.currencymaster.CurrencyNameStore',
                valueField: 'value',
                displayField: 'value',
                editable: false,
                labelAlign: 'top',
                allowBlank: false
            },{
            	xtype: 'customcombobox',
                name: 'currencyCode',
                itemId : 'currencyCode',
                fieldLabel: getCommonTranslation('CURRENCY_CODE'), //Currency Code
                store: 'othermasters.currencymaster.CurrencyCodeStore',
                valueField: 'id',
                displayField: 'value',
                editable: false,
                labelAlign: 'top',
                allowBlank: false,
                readOnly: true
            }]
        },{
            xtype: 'fieldcontainer',
            layout: 'hbox',
            defaults: {
                labelAlign: 'top',
                width: 256
            },
            items: [{
                xtype: 'statusCombo',
                itemId: 'status',
                name: 'status',
                editable: false,
                allowBlank: false
            }]
        }, {
            xtype: 'fieldcontainer',
            width: '100%',
            items: [{
                xtype: 'button',
                text: getCommonTranslation('SAVE'),
                itemId: 'btnSaveCurrencyMainForm',
                ui: 'CustomBtnSubmit',
                scale: CONSTANTS.BUTTONSIZE,
                formBind: true
            }, {
                xtype: 'button',
                text: getCommonTranslation('CANCEL'),
                ui: 'CustomBtnCancel',
                itemId: 'btnCancelCurrencyMainForm',
                scale: CONSTANTS.BUTTONSIZE
            }]
        }]

    }]
});