/**
 * @author Amit G
 * 
 * This component is used for to show window with new currency master details. 
 */
Ext.define('Academia.view.othermasters.currencymaster.ExchangeRateCurrencyFormSetUpWindow', {
    extend: 'Ext.window.Window',
    alias: 'widget.exchangeratecurrencyformsetupwindow',
    modal: true,
    resizable: false,
    title: getCommonTranslation('CURRENCY_MASTER_DETAILS'), //Currency Details	
    items: [{
        xtype: 'form',
        itemId: 'exchangeRateCurrencyForm',
        plugins: "formlabelrequired",
        standardSubmit: false,
        items: [{
            xtype: 'hidden',
            itemId: 'Exchange_hidden_field',
            name: 'id'
        }, {
            xtype: 'hidden',
            name: 'version'
        }, {
            xtype: 'hidden',
            name: 'currencyExchangeRateId'
        }, {
            xtype: 'fieldcontainer',
            layout: 'hbox',
            defaults: {
                labelAlign: 'top',
                width: 256
            },
            items: [{
            	xtype: 'customcombobox',
                name: 'name',
                itemId : 'name',
                fieldLabel: getCommonTranslation('FROM_CURRENCY'), //Currency Name
                store: 'othermasters.currencymaster.CurrencyMasterFindALLCurrenciesStore',
                valueField: 'id',
                displayField: 'name',
                editable: false,
                labelAlign: 'top',
                allowBlank: false
            },{
            	xtype: 'customcombobox',
                name: 'currencyCode',
                itemId : 'currencyCode',
                fieldLabel: getCommonTranslation('CURRENCY_CODE'), //Currency Code
                store: 'othermasters.currencymaster.CurrencyMasterFindALLCurrenciesStore',
                valueField: 'id',
                displayField: 'currencyCode',
                editable: false,
                labelAlign: 'top',
                allowBlank: false,
                readOnly: true
            }]
        }, {
            xtype: 'fieldcontainer',
            layout: 'hbox',
            defaults: {
                labelAlign: 'top',
                width: 256
            },
            items: [{
            	xtype: 'customcombobox',
                name: 'toCurrencyName',
                itemId : 'toCurrencyName',
                fieldLabel: getCommonTranslation('TO_CURRENCY'), //Currency Name
                store: 'othermasters.currencymaster.CurrencyMasterFindALLCurrenciesStore',
                valueField: 'id',
                displayField: 'name',
                editable: false,
                labelAlign: 'top',
                allowBlank: false
            },{
            	xtype: 'customcombobox',
                name: 'toCurrencyCode',
                itemId : 'toCurrencyCode',
                fieldLabel: getCommonTranslation('CURRENCY_CODE'), //Currency Code
                store: 'othermasters.currencymaster.CurrencyMasterFindALLCurrenciesStore',
                valueField: 'id',
                displayField: 'currencyCode',
                editable: false,
                labelAlign: 'top',
                allowBlank: false,
                readOnly: true
            },{
                fieldLabel: getCommonTranslation('CURRENCY_EXCHANGE_RATE'), 
                xtype: 'numberfield',
                decimalPrecision: 2,
                maxLength: 6,
                minValue: 0,
                allowExponential: false,
                allowDecimals: true,
                itemId: 'currencyExchangeRate',
                name: 'exchangeRate',
                allowBlank: false
            }]
        }, {
            xtype: 'fieldcontainer',
            layout: 'hbox',
            defaults: {
                labelAlign: 'top',
                width: 256
            },
            items: [{
                xtype: 'datefield',
                name: 'applicableFrom',
                itemId: 'applicableFrom',
                editable: false,
            	endDateField : 'applicableTo',
				//format : CONSTANTS.DMY_SLASH_DATE_FORMAT,
				vtype : 'daterange',
                fieldLabel: getCommonTranslation('APPLICABLE_FROM'),
                listeners: {
					render: function(field) {
						return dateFormatRender(field);
					}
				}
            },{
                xtype: 'datefield',
                name: 'applicableTo',
                itemId: 'applicableTo',
                allowBlank: false,
                editable: false,
                startDateField : 'applicableFrom',
				//format : CONSTANTS.DMY_SLASH_DATE_FORMAT,
				vtype : 'daterange',
                fieldLabel: getCommonTranslation('Valid_Till'),
                listeners: {
					render: function(field) {
						return dateFormatRender(field);
					}
				}
            }, {
                xtype: 'statusCombo',
                itemId: 'status',
                name: 'status',
                editable: false,
                allowBlank: false
            }]
        }, {
            xtype: 'fieldcontainer',
            width: '100%',
            items: [{
                xtype: 'button',
                text: getCommonTranslation('SAVE'),
                itemId: 'btnSaveExchangeRateCurrencyForm',
                ui: 'CustomBtnSubmit',
                scale: CONSTANTS.BUTTONSIZE,
                formBind: true
            }, {
                xtype: 'button',
                text: getCommonTranslation('CANCEL'),
                ui: 'CustomBtnCancel',
                itemId: 'btnCancelExchangeRateCurrencyForm',
                scale: CONSTANTS.BUTTONSIZE
            }]
        }]

    }]
});