/**
 * @author trupti.paoneker
 * 
 * This component is used for to show window with deficit credit master details. 
 */
Ext.define('Academia.view.othermasters.deficitmaster.DeficitCreditMasterFormWindow', {
    extend: 'Ext.window.Window',
    alias: 'widget.deficitmasterformwindow',
    modal: true,
    resizable: false,
    title: getCommonTranslation('DEFICIT_MASTER_DETAILS'), 
    items: [{
        xtype: 'form',
        itemId: 'deficitMasterForm',
        plugins: "formlabelrequired",
        standardSubmit: false,
        defaults: {
            labelAlign: 'top',
            width: 536
        },
        items: [{
            xtype: 'hidden',
            itemId: 'deficitMaster_hidden_field',
            name: 'id'
        }, {
            xtype: 'hidden',
            name: 'version'
        }, {
            xtype: 'nestedJsonCombo',
            fieldLabel: getCommonTranslation('COURSE_NAME'),
            name: 'course',
            itemId: 'courseCombo',
            valueField: 'id',
            displayField: 'value',
            store: 'course.CourseComboStore',
            editable: false,
            allowBlank: false,
            matchFieldWidth:true
        }, {
     		 xtype: 'fieldcontainer',
     	    	width: 'auto',
     	    	defaults: {
     	    		labelAlign: 'top',
     	    		width: 256
     	    	},
     	    	layout: {
     	    		type: 'hbox'
     	    	},
     	    	items:[{
     	    		xtype: 'nestedJsonCombo',
			            fieldLabel: getCommonTranslation('GRADE_TYPE'),
			            name: 'gradesGroup',
			            itemId: 'gradesGroup',
			            valueField: 'id',
			            displayField: 'value',
			            store: 'gradeMaster.GradeTypeNameValueStore',
			            editable: false,
			            allowBlank: false,
			            matchFieldWidth:true
     	    	},{
     	           xtype: 'nestedJsonCombo',
     	           fieldLabel: getCommonTranslation('EVAL_GRADE'),
     	           name: 'grade',
     	           itemId: 'evalGrade',
     	           valueField: 'id',
     	           displayField: 'grade',
     	           store: 'gradeMaster.GradeGroupMapping',
     	           editable: false,
     	           queryMode: 'local',
     	           allowBlank: false,
     	          matchFieldWidth:true
     	       }]
     	
	 }, {
           fieldLabel: getCommonTranslation('DEFICIT_POINTS'),
           xtype: 'numberfield',
           hideTrigger : true,
           minValue : 0,
           itemId: 'deficitPoints',
           width: 256,
           name: 'deficitPoints',
           allowBlank: false,
           matchFieldWidth:true
       }, {
            xtype: 'fieldcontainer',
            width: '100%',
            items: [{
                xtype: 'button',
                itemId: 'btnSaveDeficitMasterForm',
                text: getCommonTranslation('SUBMIT'), //Submit
                ui: 'CustomBtnSubmit',
                scale: CONSTANTS.BUTTONSIZE,
                formBind: true
            }, {
                xtype: 'button',
                itemId: 'btnCancelDeficitMasterForm',
                text: getCommonTranslation('CANCEL'), //Cancel
                ui: 'CustomBtnCancel',
                scale: CONSTANTS.BUTTONSIZE
            }]
        }]

    }]
});
