/**
 * Akshay Sharma
 * Filters for ProgramGroupMaster
 * 
 */
Ext.define('Academia.view.othermasters.programGroupMaster.ProgramGroupMasterFilter',
		{
	extend : 'Ext.form.FormPanel',
	alias : 'widget.programgroupmasterfilter',
	plugins : "formlabelrequired",
	autoScroll: true,
	frame: false,
	cls : 'customSearchPanel',
	//layout : 'vbox',
	method : 'POST',
	standardSubmit : false,
	items : [{
		xtype : 'fieldcontainer',
		itemId : 'programBatch_Id',
		width : 'auto',
		layout : {
			type : 'hbox'
		},
		defaults : {
			width: 256,
			labelAlign : 'top'
		},
		items : [{
			xtype : 'hidden',
			name : 'id'
		},{
			xtype : 'customcombobox',
			name : 'academyLocation',
			itemId : 'academyLocationId',
			fieldLabel : getProgramandcourseTranslation('ACADEMY_LOCATION'),
			store : 'common.AcademyLocationByName',
			width: 536,
			valueField : 'id',
			displayField : 'value',
			allowBlank : true,
			minChars : 3,
			typeAhead : true,
			forceSelection : true,
			hideTrigger : false,
			triggerAction : 'all',
			queryParam : 'name',
			emptyText : getCommonTranslation('ENTER_THREE_CHAR'),
			listConfig : {
				listeners : {
					beforeshow : function(
							picker) {
						picker.minWidth = picker
						.up('combobox')
						.getSize().width;
					}
				},
				loadingText : getCommonTranslation('SEARCHING'),
				emptyText : getCommonTranslation('NO_RECORDS_FOUND'),
				getInnerTpl : function() {
					return '<div class="search-item">'
					+ '{value}'
					+ '</div>';
				}
			}
		},{
			xtype : 'customcombobox',
			name : 'programGroup',
			itemId : 'Program_Group',
			fieldLabel : getCommonTranslation('PROGRAM_GROUP_NAME'),
			store:'program.ProgramGroupStore',
			valueField : 'id',
			displayField : 'value',
			forceSelection : true,
            editable: false
		}]
	},{
		xtype : 'fieldcontainer',
		width : '100%',
		layout : {
			type : 'hbox'
		},
		cls: 'customSearchPanelBtnsFieldContainerCls',
		items : [{
			xtype : 'button',
			text : getCommonTranslation('SEARCH'),
			itemId : 'programGroupMasterSearchBtn',
			//buttonAlign : 'left',
			ui : 'CustomBtnSubmit',
			scale : CONSTANTS.BUTTONSIZE,
			margin: '0 36 0 0'
		},{
			xtype : 'button',
			text : getCourseTxCommonTranslation('RESET'),
			itemId : 'programGroupMasterResetBtn',
			//buttonAlign : 'left',
			ui : 'CustomBtnCancel',
			scale : CONSTANTS.BUTTONSIZE
		}]
	}]
});
