/**
 * @author Deepika Parmar
 * 
 */
Ext.define('Academia.view.outcomebasededucation.OBECorrelationFormWindow', {
    extend: 'Ext.window.Window',
    alias: 'widget.obecorrelationformwindow',
    modal: true,
    resizable: false,
    title: getExaminationTranslation('OBE_CORRELATION_PERCENT'),
    margin: 0,
    items: [{
        xtype: 'form',
        itemId: 'obeCorrelationFormItemId',
        plugins: "formlabelrequired",
        standardSubmit: false,
        items: [{
            xtype: 'hidden',
            itemId: 'hideCorrelationId',
            name: 'id'
        },   {
            xtype: 'fieldcontainer',
            layout: {
                type: 'hbox'
            },
            defaults: {
                labelAlign: 'top',
                width: 256
            },
            items: [{
                fieldLabel:  getCommonTranslation('CORRELATION_LEVEL_NAME'),
                xtype: 'textfield',
                itemId: 'codeItemId',
                name: 'code',
                labelAlign: 'top',
                maxLength: 255,
                allowBlank: false
            }, {
                fieldLabel: getCommonTranslation('CORRELATION_LEVEL_PERCENTAGE'),
                xtype: 'numberfield',
                hideTrigger:true,
                itemId: 'itemValueItemId',
                name: 'doubleValue',
                labelAlign: 'top',
                maxLength: 3,
                maxValue:100,
                allowBlank: false,
                autoStripChars: true
            }]
        }, {
            xtype: 'fieldcontainer',
            width: '100%',

            items: [{
                xtype: 'button',
                itemId: 'btnSaveObeCorrelationForm',
                text: getCommonTranslation('SAVE'),
                ui: 'CustomBtnSubmit',
                scale: CONSTANTS.BUTTONSIZE,
                formBind: true
            }, {
                xtype: 'button',
                itemId: 'btnCancelObeCorrelationForm',
                text: getCommonTranslation('CANCEL'),
                ui: 'CustomBtnCancel',
                scale: CONSTANTS.BUTTONSIZE
            }]
        }]

    }]
});
