/**
 *  @author Priyanshi sharma
 */
Ext.define('Academia.view.personinfo.BankDetails.StudentBankDetailsGrid', {
	extend: 'Ext.grid.Panel',
	alias : 'widget.studentbankdetailsgrid',
	store: 'personinfo.common.personalinfo.BankDetailsGridStore',
	title: getCommonTranslation('BANK_DETAILS'),
	border: true,
	refreshStoreData:true,
	viewConfig : {
		stripeRows : CONSTANTS.STRIPEROWS
	},
	dockedItems: [{
		xtype : 'toolbar',
		dock : 'bottom',
		items : [ {
			xtype : 'custompagingtoolbar',
			plugins:['pagesize'],
			store : 'personinfo.common.personalinfo.BankDetailsGridStore',
			emptyMsg: getCommonTranslation('NORESULTSNMESSAGE'),
			displayInfo : true
		}]
	}],
	tbar: [{
		xtype: 'button',
		itemId: 'btnAdd',
		tooltip: getCommonTranslation('ADD'),
		glyph: ICONGLYPH.ADDGLYPH
	},{
		xtype: 'button',
		itemId: 'btnEdit',
		tooltip: getCommonTranslation('EDIT'),
		glyph: ICONGLYPH.EDITGLYPH
	},{
        xtype: 'button',
        itemId: 'btnView',
        tooltip: getCommonTranslation('VIEW'),
        iconCls: 'view-icon'
    },{
		xtype: 'button',
		itemId: 'btnDelete',
		cls: 'CustomToolbarBtnReject',
		tooltip: getCommonTranslation('DELETE'),
		glyph: ICONGLYPH.DELETEGLYPH
	}],
	columns: [{
		header : getCommonTranslation('BENEFICIARY_NAME'),
		dataIndex : 'beneficiaryName',
		flex:1
	},{
		header : getCommonTranslation('BENEFICIARY_NAME_OTHER_LANGUAGE'),
		dataIndex : 'beneficiaryNameOtherLanguage',
		flex:1,
		hidden:true
	},{
		header : getCommonTranslation('ACCOUNT_NUMBER'),
		dataIndex : 'accountNumber',
		flex:1
	},{
		header : getCommonTranslation('ACCOUNT_TYPE'),
		dataIndex : 'accountTypeName',
		flex : 1
	},{
		header : getCommonTranslation('BANK_NAME'),
		dataIndex : 'bankDrawnOnMasterName',
		flex : 1
	},{
		header : getCommonTranslation('BRANCH_NAME'),
		dataIndex : 'branchName',
		flex : 1
	},{
		header : getCommonTranslation('IFSC_CODE'),
		dataIndex : 'ifscCode',
		flex : 1
	}],
});