Ext.define('Academia.view.personinfo.common.ParentGuardianCardTpl', {
    extend: 'Ext.panel.Panel',
    alias: 'widget.parentguardiancardtpl',
    title: '',
	flex: 1,
	layout: {
	    type: 'vbox',
	    align: 'stretch'
	},
    columnWidth:0.495,
    border: true,
    height: 280,
    cls: 'parentgaurdiancards',
	items: [
		{
			xtype: 'panel',
			layout: 'hbox',
	    	flex: 1,
	    	autoScroll:true,
	    	cls: 'pgCardLayoutUprPnl',
	        style: 'height:130px !important',
			items:[{
				xtype: 'fieldcontainer',
				flex: 8,
				defaults: {
					labelWidth: 125,
					labelStyle: 'white-space: nowrap;width:auto'
				},
				items:[{
					xtype: 'displayfield',
					fieldLabel: getPersonModuleTranslation('NAME'),
					value: '',
					labelWidth: 40,
					name: 'pgNameField',
					fieldStyle: 'text-transform: capitalize;font-weight: bold;margin-top: -1px !important;white-space: nowrap;text-overflow: ellipsis;max-width: 36ch;overflow: hidden;',
					listeners: {
			            change: function(df, newValue, oldValue, eOpts) {
			            	Ext.query('#'+df.el.dom.id+'-bodyEl')[0].title = newValue;
			            }
			        }
				},
				{
					xtype: 'displayfield',
					fieldLabel: getPersonModuleTranslation('USER_CODE'),
					value: '',
					labelWidth: 66,
					name: 'pgUserCodeField',
					listeners: {
			            change: function(df, newValue, oldValue, eOpts) {
			            	Ext.query('#'+df.el.dom.id+'-bodyEl')[0].title = newValue;
			            }
			        }
				},
				{
					xtype: 'displayfield',
					fieldLabel: getPersonModuleTranslation('EMAIL_ID'),
					value: '',
					labelWidth: 55,
					name: 'pgEmailField',
					listeners: {
			            change: function(df, newValue, oldValue, eOpts) {
			            	Ext.query('#'+df.el.dom.id+'-bodyEl')[0].title = newValue;
			            }
			        }
				},
				{
					xtype: 'displayfield',
					fieldLabel: getCommonTranslation('MOBILE_NO'),
					value: '',
					labelWidth: 68,
					name: 'pgMobileNoField',
					listeners: {
			            change: function(df, newValue, oldValue, eOpts) {
			            	Ext.query('#'+df.el.dom.id+'-bodyEl')[0].title = newValue;
			            }
			        }
				},
				{
					xtype: 'displayfield',
					fieldLabel: getCommonTranslation('ALTERNATE_MOBILE_NO'),
					value: '',
					labelWidth: 125,
					name: 'pgAltMobileField',
					listeners: {
			            change: function(df, newValue, oldValue, eOpts) {
			            	Ext.query('#'+df.el.dom.id+'-bodyEl')[0].title = newValue;
			            }
			        }
				},
				{
					xtype: 'displayfield',
					fieldLabel: getCommonTranslation('HAS_ACCESS_TO_STUDENT'),
					value: '',
					labelWidth: 110,
					name: 'pgAltHasAccessField',
					listeners: {
			            change: function(df, newValue, oldValue, eOpts) {
			            	Ext.query('#'+df.el.dom.id+'-bodyEl')[0].title = newValue;
			            }
			        }
				}]
			},{
				xtype: 'image',
				src: 'resources/images/profile_student.png',
				width: 100,
				height: 120,
				cls:'parentStudentImageCls'
			}]
		},
		{
			xtype: 'panel',
	    	//flex: 1,
	    	cls: 'pgCardLayoutBtnPnl',
	    	layout: 'hbox',
	    	defaults:{
	    		cls:'btn-with-no-icon',
	    		style:{
	    			'margin-left':'5px !important'
	    		}
	    	},
	    	items: [{
	            xtype: 'button',
	            text: getCommonTranslation('ADD_DETAILS'),
	            itemId: 'addDetails_PG_ItemId',
	            ui: 'CustomBtnSubmit',
	            scale: CONSTANTS.BUTTONSIZE
	        },{
	            xtype: 'button',
	            text: getCommonTranslation('EDIT'),
	            itemId: 'edit_PG_ItemId',
	            ui: 'CustomBtnSubmit',
	            scale: CONSTANTS.BUTTONSIZE
	        },{
	            xtype: 'button',
	            text: getCommonTranslation('VIEW'),
	            itemId: 'view_PG_ItemId',
	            ui: 'CustomBtnSubmit',
	            scale: CONSTANTS.BUTTONSIZE
	        },{
	            xtype: 'button',
	            text: getCommonTranslation('DELETE'),
	            itemId: 'delete_PG_ItemId',
	            ui: 'CustomBtnSubmit',
	            scale: CONSTANTS.BUTTONSIZE
	        },{
	            xtype: 'button',
	            text: getCommonTranslation('Create Login'),
	            itemId: 'createLogin_PG_ItemId',
	            ui: 'CustomBtnSubmit',
	            scale: CONSTANTS.BUTTONSIZE
	        },{
	            xtype: 'button',
	            text: getCommonTranslation('Reset Password'),
	            itemId: 'resetPassword_PG_ItemId',
	            ui: 'CustomBtnSubmit',
	            scale: CONSTANTS.BUTTONSIZE
	        },{
	            xtype: 'button',
	            text: getCommonTranslation('SSO'),
	            itemId: 'sso_PG_ItemId',
	            ui: 'CustomBtnSubmit',
	            scale: CONSTANTS.BUTTONSIZE
	        }]
		}
	]
});