/**
 * @author Pravin.Surve
 */

Ext.define('Academia.view.personinfo.common.course.AttendanceQuickSearchGrid', {
    //extend: 'Ext.grid.Panel',
	extend: 'Academia.view.facilitiesresources.resourcebooking.StaticGridExcelExport',
	alias: 'widget.attendanceQuickSearchGrid',
    title: getPersonModuleTranslation('ATTENDANCE_FOR'),
    border: true,
    autoScroll: true,
    viewConfig: {
        stripeRows: CONSTANTS.STRIPEROWS
    },
   tbar: [{
        xtype: 'button',
        itemId: 'btnView',
        tooltip: getCommonTranslation('VIEW'),
        iconCls: 'view-icon'
    }],
    columns: [{
        header: getPersonModuleTranslation('COURSES'),
        dataIndex: 'courseName',
        sortable:true,
        flex: .1
    }, {
        header: getPersonModuleTranslation('SESSION_TO_BE_CONDUCTED'),
        dataIndex: 'sessionPlanned',
        sortable: true,
        hidden:true,
        flex: .1
    },  {
        header: getPersonModuleTranslation('SESSION_PLANNED'),
        dataIndex: 'sessionPlanned',
//        dataIndex: 'totalRecords',
        sortable:true,
        flex: .1
    },{
        header: getPersonModuleTranslation('SESSION_CONDUCTED'),
        dataIndex: 'sessionConducted',
//        dataIndex: 'totalRecords',
        sortable:true,
        flex: .1
    },{
        header: getPersonModuleTranslation('SESSION_ATTENDED'),
        dataIndex: 'sessionAttended',
//        dataIndex: 'presentRecords',
        sortable:true,
        flex: .1
    },{
        header: getPersonModuleTranslation('STUDENT_TOTAL'),
        dataIndex: 'totalRecords',
        sortable:true,
        hidden: true,
        flex: .1
    },{
        header: getCommonTranslation('TOTAL_RECORDS'),
        dataIndex: 'totalRecords',
        sortable:true,
        hidden: true,
        flex: .1
    },{
        header: getPersonModuleTranslation('STUDENT_TOTAL_PRESENT'),
        dataIndex: 'presentRecords',
        sortable:true,
        hidden: true,
        flex: .1
    },{
        header: getPersonModuleTranslation('STUDENT_TOTAL_ABSENT'),
        dataIndex: 'presentRecords',
        sortable:true,
        hidden: true,
        flex: .1
    },{
        header: getPersonModuleTranslation('ATTENDANCE_PERCENTAGE'),
        dataIndex: 'attendancePercentage',
        sortable:true,
        flex: .1
    }],
    
    initComponent: function() {
        var this$ = this;
        var store = (this$.personType == 'STUDENT')?this$.buildStudentStore():this$.buildFacultyStore();
        Ext.apply(this$, {
            store: store,
            dockedItems: [{
                xtype: 'toolbar',
                dock: 'bottom',
                items: [{
                    xtype: 'custompagingtoolbar',
                    plugins: ['pagesize'],
                    store: store,
                    emptyMsg: getCommonTranslation('EMPTY_MESSAGE'),
                    displayInfo: true
                }]
            }]
        });
        this$.addExportToolBarItems(this$);
        this$.callParent(arguments);
    },
    buildStudentStore: function() {
        return Ext.create('Academia.store.personinfo.common.course.CourseAttendanceStore');
    },
    buildFacultyStore: function() {
        return Ext.create('Academia.store.personinfo.common.course.FacutlyCourseAttendanceStore');
    }
});