/**
 * This form is used for  faculty attendance details
 * @author pravin.surve
 */
Ext.define('Academia.view.personinfo.common.course.FacultyTeachingHourQuickSearchForm', {
    extend: 'Ext.form.Panel',
    alias: 'widget.facultyteachinghourquicksearchform',
    frame: false,
    plugins: "formlabelrequired",
    cls:'customSearchPanel',
    items: [{
    	xtype: 'hidden',
    	itemId: 'facultyAttendance_hidden_type',
    	name: 'facultyAttendanceType'
    },{
        xtype: 'fieldcontainer',
        layout: 'hbox',
        itemId: 'programBatchPeriodContainer',
        defaults: {
            labelAlign: 'top',
            width: 256
        },
        items: [{
			xtype : 'customcombobox',
			fieldLabel : getCommonTranslation('ACADEMIC_TERM'),		
			name : 'ACADEMIC_TERM',
			itemId : 'academicTerm',
			displayField : 'value',
			store:Ext.create('Academia.store.common.AcademicTermStoreForIntakeYearId'),
			valueField : 'id',
			typeAhead : true,
			allowBlank : false,
			editable : false,
			
		}]
    },  {
        xtype: 'fieldcontainer',
        width: '100%',
		cls: 'customSearchPanelBtnsFieldContainerCls',
        items: [{
            xtype: 'button',
            text: getCommonTranslation('SEARCH'),
            itemId: 'attendanceSearchButtonId',
            ui: 'CustomBtnSubmit',
            scale: CONSTANTS.BUTTONSIZE,
            formBind: true
        },{
            xtype: 'button',
            text: getCompletionModuleTranslation('CLEAR_SEARCH'),
            itemId: 'clearSearch',
            buttonAlign: 'right',
            ui: 'CustomBtnCancel',
            scale: CONSTANTS.BUTTONSIZE,
            listeners: {
                click: function(button, eOpts) {
                	this.up('form').getForm().reset();
                }
            }
        }]
    }]
});