/**
 * This form is used for my course details
 * @author Sumit.meena
 */
Ext.define('Academia.view.personinfo.common.course.MyCourseQuickSearchForm', {
    extend: 'Ext.form.Panel',
    alias: 'widget.mycoursequicksearchform',
    frame: false,
    plugins: "formlabelrequired",
    cls:'customSearchPanel',
    items: [{
        xtype: 'hidden',
        itemId: 'studentHiddenId'
    },{
        xtype: 'hidden',
        itemId: 'programHiddenId'
    }, {
        xtype: 'hidden',
        itemId: 'batchHiddenId'
    }, {
        xtype: 'hidden',
        itemId: 'periodHiddenId'
    }, {
        xtype: 'hidden',
        itemId: 'sectionHiddenId'
    },{
        xtype: 'fieldcontainer',
        layout: 'hbox',
        defaults: {
            labelAlign: 'top',
            width: 536
        },
        items: [{
			xtype : 'radiogroup',
			itemId:'coruseTypeId',
//			fieldLabel:getProgramandcourseTranslation('VIEW_ATTENDANCE_FOR'),
			items : [{
				boxLabel : getPersonModuleTranslation('COURSE'),
				name:'courseWise',
				itemId:'courseWise',
				inputValue : true,
				checked : true
			},{
				boxLabel : getPersonModuleTranslation('PERIOD'),
				name:'courseWise',	
				itemId:'periodWise',
				inputValue : false

			}]
        }
        ]},{
        xtype: 'fieldcontainer',
        layout: 'hbox',
        defaults: {
            labelAlign: 'top',
            width: 256
        },
        items: [{
			xtype : 'customcombobox',
			name : 'studentAcademyLocation',
			itemId:'studentAcademyLocation',
			fieldLabel : getProgramandcourseTranslation('ACADEMY_LOCATION'),
			store:Ext.create('Academia.store.coursetransaction.studentenrollment.AcademyLocationsByAdmissionStore'),
			valueField : 'id',
			displayField : 'value',
			minChars:3,
			typeAhead : false,
			forceSelection:true,
			hideTrigger:false,
			triggerAction: 'all',
			queryParam:'qry',
            //allowBlank: false,
            width: 536,
			listConfig: {
				listeners: {
					beforeshow: function(picker) {
						picker.minWidth = picker.up('combobox').getSize().width;
					}
				},
				loadingText: getCommonTranslation('SEARCHING'),
				emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
				getInnerTpl: function() {
					return '<div class="search-item">' +
					'{value}' +
					'</div>';
				}
			}
		}]
    },{
        xtype: 'fieldcontainer',
        layout: 'hbox',
        defaults: {
            labelAlign: 'top',
            width: 256
        },
        items: [{
            xtype: 'customcombobox',
            name: 'programId',
            itemId: 'attendanceProgram',
            fieldLabel: getCommonTranslation('PROGRAM_CODE_OR_NAME'),
           // editable: false,
            allowBlank: true,
            valueField: 'id',
            displayField: 'valueCode',
           // queryMode: 'local',
            queryParam:'programName',
            minChars:3,
  			typeAhead:false,
              emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
              forceSelection:true,
            listeners: {
                render: function(combo) {
                    var store = Ext.create('Academia.store.student.studentprofile.StudentProgramStore');
                    combo.bindStore(store);
                }
            },listConfig: {
                listeners: {
                    beforeshow: function(picker) {
                      picker.minWidth = picker.up('combobox').getSize().width;
                      }
                    },
                    loadingText: getCommonTranslation('SEARCHING'),
                    emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
                    getInnerTpl: function() {
                      return '<div class="search-item">' +
                      '{code} / {value}'+
                      '</div>';
                      }
                    }
        }, {
            xtype: 'customcombobox',
            name: 'batch',
            itemId: 'batchCombo',
            valueField: 'id',
            displayField: 'value',
            queryMode: 'local',
            //allowBlank: false,
            editable: false,
            fieldLabel: getCommonTranslation('BATCH'),
            listeners: {
                render: function(combo) {
                    var store = Ext.create('Academia.store.student.studentprofile.StudentProgramStore');
                    combo.bindStore(store);
                }
            }
        },{
            xtype: 'customcombobox',
            name: 'period',
            itemId: 'period',
            fieldLabel: getPersonModuleTranslation('ATTENDANCE_PERIOD'),
            editable: false,
            valueField: 'id',
            displayField: 'value',
            queryMode: 'local',
            listeners: {
                render: function(combo) {
                	combo.courseWise = true;
//                    var store = Ext.create('Academia.store.student.studentprofile.StudentProgramStore');
                    var store = Ext.create('Academia.store.program.programDetails.programBatches.courseParameter.ProgramCoursePeriod');
                    combo.bindStore(store);
                }
            }
        },
     ]
    },
    {
        xtype: 'fieldcontainer',
        layout: 'hbox',
        defaults: {
            labelAlign: 'top',
            width: 256
        },
        items: [{
    		xtype: 'checkboxfield',
			boxLabel : getProgramandcourseTranslation('SHOW_COURSE_INCLUDING_WITHDRWAN'),
			name:'showCourseIncludingWithdrawn',
			itemId:'showCourseIncludingWithdrawn',
			inputValue : false,
		}]
    },{
        xtype: 'fieldcontainer',
        layout: 'hbox',
        defaults: {
            labelAlign: 'top',
            width: 256
        },
        items: [{
			xtype : 'customcombobox',
			fieldLabel : getCourseTxCommonTranslation('SECTION'),
			name : 'section',
			itemId : 'sectionId',
            valueField: 'id',
            displayField: 'value',
			hidden:true,
			listeners: {
                render: function(combo) {
                    var store = Ext.create('Academia.store.student.studentprofile.StudentProgramStore');
                    combo.bindStore(store);
                }
            }
		},{
    		xtype: 'customcombobox',
    		name: 'courseCompletionStatus',
    		itemId:'courseCompletionStatusItemId',
//    	    store:'examinationcenters.repetitioncompletion.CourseCompletionStatus',
    		displayField:'value',
    		valueField:'id',
    		fieldLabel:getExaminationTranslation('COURSE_COMPLETION_STATUS'),    		
    		forceSelection:true,
//    		allowBlank:false,
    		hidden:true,
    		listeners: {
                render: function(combo) {
                    var store = Ext.create('Academia.store.examinationcenters.repetitioncompletion.CourseCompletionStatus');
                    combo.bindStore(store);
                }
            }
    	}]
    }, {
        xtype: 'fieldcontainer',
        width: '100%',
		cls: 'customSearchPanelBtnsFieldContainerCls',
		layout: 'hbox',
        items: [{
            xtype: 'button',
            text: getCommonTranslation('SEARCH'),
            itemId: 'attendanceSearchButtonId',
            ui: 'CustomBtnSubmit',
            formBind: true,
            scale: CONSTANTS.BUTTONSIZE
        }, {
            xtype: 'button',
            text: getCompletionModuleTranslation('CLEAR_SEARCH'),
            itemId: 'clearSearch',
            ui: 'CustomBtnCancel',
            scale: CONSTANTS.BUTTONSIZE
            /*listeners: {
                click: function(button, eOpts) {
                	this.up('form').getForm().reset();
                }
            }*/
        }]
    }]
});