Ext.define('Academia.view.personinfo.common.course.PerformanceTrackerForm', {
    extend: 'Ext.form.Panel',
    alias: 'widget.performancetrackerform',
    bodyStyle: {
        overflow: 'auto !important'
    },
    initComponent: function() {

        this.items = [{
            xtype: 'fieldcontainer',
            width: '100%',
            defaults: {
                labelWidth: 200
            },
            items: [{
                xtype: 'customcombobox',
                name: 'program',
                itemId: 'studentPerformanceCombo',
                store: 'personinfo.common.course.PerformanceComboStore',
                fieldLabel: getPersonModuleTranslation('STUDENT_PERFORMANCE'),
                
                editable: false,
                valueField: 'id',
                displayField: 'value',
                value: 'ACADEMIC'
            }, {
                xtype: 'customcombobox',
                name: 'program',
                itemId: 'studentProgramCombo',
//                store: 'common.ProgramStore',
                fieldLabel: getPersonModuleTranslation('PERFORMANCE_PROGRAM'),
                
                editable: false,
                valueField: 'id',
                displayField: 'value'
            }]
        }, {
            xtype: 'fieldcontainer',
            itemId: 'studentEvaluationResults',
            //            layout : 'fit',
            autoHeight: true,
            defaults: {
                labelWidth: 200
            },
            items: [{
                xtype: 'fieldset',
                itemId: 'studentPerformanceSnapshot',
                title: getPersonModuleTranslation('CURRENT_PERFORMANCE_SNAPSHOT'),
                border: true,
                collapsible: true,
                collapsed: false,
                items: [this.getStudentPerformanceView()]
            }, {
                xtype: 'radiogroup',
                fieldLabel: getPersonModuleTranslation('EVALUATION_RESULTS'),
                columns: 3,
                vertical: true,
                items: [{
                    boxLabel: getPersonModuleTranslation('INTERNAL'),
                    name: 'exam',
                    inputValue: '1',
                    checked: true
                }, {
                    boxLabel: getPersonModuleTranslation('EXTERNAL'),
                    name: 'exam',
                    inputValue: '2'
                }, {
                    boxLabel: getPersonModuleTranslation('OVERALL'),
                    name: 'exam',
                    inputValue: '3'
                }]
            }]
        }, {
            xtype: 'fieldset',
            title: getPersonModuleTranslation('SEMESTER'),
            border: true,
            collapsible: true,
            collapsed: false,
            margin: '0px',
            width: '100%',
            items: [{
                xtype: 'fieldset',
                itemId: 'studentEvaluationSummary',
                title: getPersonModuleTranslation('EVALUATION_SUMMARY'),
                border: true,
                margin: '0px',
                collapsible: true,
                collapsed: false,
                items: [this.getStudentEvaluationSummary()]
            }, {
                xtype: 'performancsetrackergrid',
                itemId: 'performancseTrackerGrid'
            }]
        }];

        this.callParent(arguments);
    },
    getStudentPerformanceView: function() {
        var studentPerformanaceSnapshot = new Ext.XTemplate('<tpl for=".">', '<div class="thumb-wrap">', '<table width="100%">', '<tr><td>' + getPersonModuleTranslation('CUMULATIVE_MARKS_GRADES') + ': {currentRanks}</td><td>' + getPersonModuleTranslation('DEFICIT_CREDIT') + ': {currentRanks}</td><td>' + getPersonModuleTranslation('DEFICIT_COURSES') + ': {currentRanks}</td></tr>', '<tr><td>' + getPersonModuleTranslation('CURRENT_RANKS') + ': {currentRanks}</td><td>' + getPersonModuleTranslation('CREDIT_COMPLETED') + ': {currentRanks}</td><td>' + getPersonModuleTranslation('COURSE_COMPLETED') + ': {currentRanks}</td></tr>', '<tr><td>' + getPersonModuleTranslation('PROGRAM_RANK') + ': {currentRanks}</td><td>' + getPersonModuleTranslation('CREDIT_REQUIRED_COMPLETED') + ': {currentRanks}</td><td>' + getPersonModuleTranslation('COURSES_REQUIRED_COMPLETED') + ': {currentRanks}</td></tr>', '</table></div>', '</tpl>');
        var StudentPerformanceView = Ext.define('Academia.view.personinfo.course.StudentPerformanceView', {
            extend: 'Ext.view.View',
            alias: 'widget.studentperformanceview',
//            store: 'personinfo.student.StudentProfileStore',
            tpl: studentPerformanaceSnapshot,
            itemSelector: 'div.thumb-wrap',
            emptyText: getPersonModuleTranslation('NO_INFORMATION_AVAILABLE')
        });

        return StudentPerformanceView;
    },
    getStudentEvaluationSummary: function() {
        var studentEvalutionSummary = new Ext.XTemplate('<tpl for=".">', '<div class="thumb-wrap">', '<table width="100%">', '<tr><td>' + getPersonModuleTranslation('NUMBER_OF_COURSES') + ' : {currentRanks}</td><td>' + getPersonModuleTranslation('PERIOD_GRADES') + ' : {currentRanks}</td><td>' + getPersonModuleTranslation('NUMBER_OF_AUDIT_COURSES') + ': {currentRanks}</td></tr>', '<tr><td>' + getPersonModuleTranslation('COURSES_PASSED') + ': {currentRanks}</td><td>' + getPersonModuleTranslation('PERIOD_CUMULATIVE_MARKS') + ': {currentRanks}</td><td>' + getPersonModuleTranslation('DEFICIT_CREDIT') + ': {currentRanks}</td></tr>', '<tr><td>' + getPersonModuleTranslation('COURSES_FAILED') + ': {currentRanks}</td><td>' + getPersonModuleTranslation('PROGRAM_RANK') + ': {currentRanks}</td><td></td></tr>', '</table></div>', '</tpl>');
        var StudentEvalutionSummaryView = Ext.define('Academia.view.personinfo.course.StudentEvalutionSummaryView', {
            extend: 'Ext.view.View',
            alias: 'widget.studentevalutionsummaryview',
//            store: 'personinfo.student.StudentProfileStore',
            tpl: studentEvalutionSummary,
            itemSelector: 'div.thumb-wrap',
            emptyText: getPersonModuleTranslation('NO_INFORMATION_AVAILABLE')
        });

        return StudentEvalutionSummaryView;
    }
});