/**
 * @author Pravin.Surve
 */
Ext.define('Academia.view.personinfo.common.course.ProgramAndCourseForm', {
    extend: 'Ext.form.Panel',
    alias: 'widget.programandcourseform',
    border : false,
    frame : false,
    plugins: "formlabelrequired",
    items: [{
        xtype: 'hidden',
        itemId: 'programcourse_hidden_field',
        name: 'id'
    }, {
        xtype: 'hidden',
        name: 'version'
    }, {
        xtype: 'fieldcontainer',
        layout: 'hbox',
        defaults: {
            labelAlign: 'top',
            width: 256
        },
            items: [{
            	xtype: 'customcombobox',
				name: 'programName',
				itemId:'programName',
				fieldLabel: getPersonModuleTranslation('PROGRAM_NAME'),
				
				store: 'common.ProgramStore',
				valueField : 'id',
				displayField : 'value',
				editable: false
            }, {
            	xtype: 'customcombobox',
				name: 'courseName',
				itemId:'courseName',
				fieldLabel: getPersonModuleTranslation('COURSE_NAME'),
				
				store: 'coursetransaction.sectioncoursecoverageplan.coursecoverageplandetail.CourseStore',
				valueField : 'id',
				displayField : 'value',
				editable: false
            }]
        }, {
            xtype: 'fieldcontainer',
            layout: 'hbox',
            defaults: {
                labelAlign: 'top',
                width: 256
            },
            items: [{
            	xtype: 'customcombobox',
	            name: 'alternateFaculty',
	            itemId:'alternateFaculty',
	            fieldLabel: getPersonModuleTranslation('ALTERNATE_FACULTY'),
	            
	            store: 'coursetransaction.facultytopicassignment.AlternateFacultyStore',
	            valueField : 'id',
				displayField : 'value',
	            editable: false
            }, {
            	xtype: 'customcombobox',
	            name: 'courseComponent',
	            itemId:'courseComponent',
	            fieldLabel: getPersonModuleTranslation('COURSE_COMPONENT'),
	            
	            store: 'course.coursecomponent.CourseComponentStore',
	            valueField : 'id',
				displayField : 'value',
	            editable: false
            }]
        },  {
            xtype: 'fieldcontainer',
            layout: 'hbox',
            defaults: {
                labelAlign: 'top',
                width: 256
            },
            items: [{
        		xtype: 'customcombobox',
	            name: 'batch',
	            itemId:'batch',
	            fieldLabel: getPersonModuleTranslation('BATCH'),
	            
	            store: 'program.programbatchdetail.BatchStore',
	            valueField : 'id',
				displayField : 'value',
	            editable: false
		    },{
				xtype: 'customcombobox',
	            name: 'section',
	            itemId:'section',
	            fieldLabel: getPersonModuleTranslation('SECTION'),
	            
	            store: 'coursetransaction.sectionmanagement.SectionsStore',
	            valueField : 'id',
				displayField : 'value',
	            editable: false
			}]
          },  {
            xtype: 'fieldcontainer',
            layout: 'hbox',
            defaults: {
                labelAlign: 'top',
                width: 256
            },
            items: [{
        		xtype: 'customcombobox',
	            name: 'period',
	            itemId:'period',
	            fieldLabel: getPersonModuleTranslation('PERIOD'),
	            
	            store: 'admission.applications.admissionAndMidTermAdmission.PeriodComboStore',
	            valueField : 'id',
				displayField : 'value',
	            editable: false
		    }]
          }, {
            xtype: 'fieldcontainer',
            width: '100%',
            
            items: [{
                xtype: 'button',
                text: getCommonTranslation('SUBMIT'),
                itemId: 'submitButtonId',
                buttonAlign: 'right',
                ui: 'CustomBtnSubmit',
                scale: CONSTANTS.BUTTONSIZE,
                formBind: true
            }, {
                xtype: 'button',
                text: getCommonTranslation('CANCEL'),
                ui: 'CustomBtnCancel',
                itemId: 'cancelButtonId',
                scale: CONSTANTS.BUTTONSIZE

            }]
        }]

});