/**
 * Schedule Details
 * @author Sachin.Bangar
 */
Ext.define('Academia.view.personinfo.common.course.ScheduleDetails', {
    extend: 'Ext.form.Panel',
    alias: 'widget.scheduledetails',
    title: getPersonModuleTranslation('SCHEDULE_DETAILS'),
    closable: true,
    autoScroll:true,
    cls: 'panelNoSpace',
    width: '100%',
    reserveScrollbar: true,
    /*bodyStyle: {
        overflow: 'auto !important'
    },*/
    defaults: {
        autoHeight: true
    },
    requires: ['Ext.picker.Date', 'Ext.calendar.util.Date', 'Ext.calendar.CalendarPanel', 
               'Ext.calendar.data.MemoryCalendarStore', 'Ext.calendar.data.MemoryEventStore', 
               'Ext.calendar.data.Events', 'Ext.calendar.data.Calendars', 'Ext.calendar.form.EventWindow'],
    initComponent: function() {
        var me = this;
        me.calendarStore = Ext.create('Ext.calendar.data.MemoryCalendarStore', {
            data: Ext.calendar.data.Calendars.getData()
        });
        me.eventStore = Ext.create('Ext.calendar.data.MemoryEventStore', {});
        Ext.apply(me, {
        	items: [{
        		xtype : 'radiogroup',
        		width: 256,
        		labelAlign : 'top',
        		fieldLabel : getPersonModuleTranslation('VIEW_CALENDAR_FOR'),
        		itemId : 'viewCalendarId',
        		style: {
        			marginLeft:'10px',
        		},
        		defaults: {
        			flex: 1
        		},
        		layout: 'hbox',
        		items : [{
        			boxLabel : getPersonModuleTranslation('VIEW_TIME_TABLE'),
        			name : 'isViewCalendar',
        			inputValue : true,
        			checked : true
        		},{
        			boxLabel : getPersonModuleTranslation('VIEW_EVENT'),
        			name : 'isViewCalendar',
        			inputValue : false
        		}]
        	},{
                xtype: 'calendarpanel',
                itemId: 'personViewCalendar',
                reserveScrollbar: true,
                toolBarDateTitleWidth: '57%',
                layout: 'fit',
                border: true,
                width: '100%',
                height: '100%',
                minHeight: 500,
                flex:1,
                region: 'center',
                eventStore: me.eventStore,
                calendarStore: me.calendarStore,
                showExportToPNG: true, 
                dayViewHeight: 1835, 
                weekViewHeight: 1835, 
                monthViewHeight: 500,
                monthViewCfg: {
                    showHeader: true,
                    showWeekLinks: true,
                    showWeekNumbers: true
                }
            }]
        });

        me.callParent(arguments);
        me.doLayout();
    }
});