/**
 * @author bhanu ps
 */
Ext.define('Academia.view.personinfo.common.course.StudentCourseReportByPeriodGrid', {
		extend: 'Academia.view.facilitiesresources.resourcebooking.StaticGridExcelExport',
		alias: 'widget.studentcoursereportbyperiodgrid',
		title: getExaminationTranslation('STUDENT_PERIOD_REPORT'),
		border: true,
		autoScroll: false,
		frame:false,
		isGridConfigurable:true,
   		enableColumnHide: false,
		viewConfig: {
			stripeRows: CONSTANTS.STRIPEROWS
		},
		selModel: {
			mode:'MULTI',
			showHeaderCheckbox: true,
			allowDeselect: false,
			checkOnly : true
		},
		tbar: [{
	         xtype: 'button',
	         itemId: 'downloadAllButtonItemId',
			 disabled:true,
			 hidden: true,
			 text:getExaminationTranslation('DOWNLOAD_ALL_MARKSHEET'),
			 tooltip :getExaminationTranslation('DOWNLOAD_ALL_MARKSHEET')
	    },{
	         xtype: 'button',
	         itemId: 'downloadUnofficialTranscriptItemId',
			 disabled:true,
			 hidden: true,
			 text:getExaminationTranslation('DOWNLOAD_UNOFFICIAL_TRANSCRIPT'),
			 tooltip :getExaminationTranslation('DOWNLOAD_UNOFFICIAL_TRANSCRIPT')
	    }],
	   
		columns: [{
			header: getCommonTranslation('PERIOD_NAME'),
			dataIndex: 'programPeriodName',
			flex:.1,
			sortable:true,
		},{
			header:getCommonTranslation('TOTAL_COURSES'),
			dataIndex: 'totalNoOfCourse',
			flex:.1,
			sortable:true,
		},{
			header:getCommonTranslation('COUNT_OF_MANDATORY_COURSES'),
			dataIndex: 'noOfMandatoryCourse',
			flex:.1,
			sortable:true,
		},{
			header:getCommonTranslation('COUNT_OF_OPTIONAL_COURSES'),
			dataIndex: 'noOfOptionalCourse',
			flex:.1,
			sortable:true,
		},{
			header:getCommonTranslation('SGPA_OR_MARKS'),
			dataIndex: 'sgpaormarks',
			flex:.1,
			sortable:true,
			renderer:function(value,meta,record){
				if(!isNullOrEmpty(record.data.sgpa)) {
					return record.data.sgpa;
				} else {
					return '-';
				}                       
			}
		},{
			header:getCommonTranslation('ACCUMULATIVE_CGPA'),
			dataIndex: 'accumulatedCGPA',
			flex:.1,
			sortable:true,
			renderer:function(value,meta,record){
				if(!isNullOrEmpty(record.data.accumulatedCGPA)) {
					return record.data.accumulatedCGPA;
				} else {
					return '-';
				}                       
			}
		},{
			header:getCommonTranslation('REVISED_SGPA'),
			dataIndex: 'revisedSGPA',
			flex:.1,
			sortable:true,
			hidden:true,
			renderer:function(value,meta,record){
				if(!isNullOrEmpty(record.data.revisedSGPA)) {
					return record.data.revisedSGPA;
				} else {
					return '-';
				}                       
			}
		},{
			header:getCommonTranslation('REVISED_CGPA'),
			dataIndex: 'revisedAccCGPA',
			flex:.1,
			sortable:true,
			hidden:true,
			renderer:function(value,meta,record){
				if(!isNullOrEmpty(record.data.revisedAccCGPA)) {
					return record.data.revisedAccCGPA;
				} else {
					return '-';
				}                       
			}
		},{
			header:getCommonTranslation('RESULT_STATUS'),
			dataIndex: 'resultStatus',
			flex:.1,
			sortable:true,
			renderer:function(value,meta,record){
				if(!isNullOrEmpty(value)) {
					return value;
				} else {
					return '-';
				} 
			}
		},{
			header:getCommonTranslation("SECTION_NAME"),
			dataIndex: 'sectionName',
			flex:.1,
			sortable:true,
			hidden:true
		},/*{
			header:getCommonTranslation("MARKSHEET_NAME"),
			dataIndex: 'marksheetType',
			flex:.1,
			sortable:true,
			hidden:true,
			renderer:function(value,meta,record){
				if(!isNullOrEmpty(value)) {
					return value;
				} else {
					return '-';
				} 
			}
		},*/{
			header:getCommonTranslation('MARKSHEET_PATH'),
			dataIndex: 'marksheetPath',
			flex:.1,
			sortable:true,
			renderer:function(value,meta,record){
				if(!isNullOrEmpty(value)) {
					return '<a href=#>'+value+'</a>'
				} else {
					return '-';
				}      
			}
		}],
		listeners: {
       
        cellclick: function(View, CellEl, ColIdx, record, RowEl, RowIdx, e, eopts) {
            var studentCountGrid = View.up('grid');
            var columnName = studentCountGrid.columnManager.columns[ColIdx].dataIndex;
            if (e.target.tagName == 'A') {
                if (columnName == 'marksheetPath') {
                    var selectedRecord = studentCountGrid.getSelectionModel().getSelection()[0];
                    var reportType = selectedRecord.get('marksheetType');
                    var templateType = selectedRecord.get('templateType');
                    var docPath = selectedRecord.get('marksheetPath');
                    var documentPath = null;
                    var submitUrl
                    if(reportType =='MARKSHEET' && templateType == 'EVALUATION_EVENT'){
                    	var fields = docPath.split('.pdf');
                        var docAtcualPath = fields[0];
                        docAtcualPath = docAtcualPath+'_ForStudentPortal' + '.pdf';
                    	documentPath = window.btoa(unescape(encodeURIComponent(docAtcualPath)))
                    } else{
                    	documentPath = window.btoa(unescape(encodeURIComponent(docPath)))
                    }
                    
                    /** For Both Hall Ticket and Marksheet download */
                    var submitUrl = SERVERURL.MARKSHEET_DOWNLOAD_URL;
                    var csvForm = Ext.create('Ext.form.Panel');
                   
                    csvForm.getForm().submit({
                        url: submitUrl + "?filePath=" + documentPath,
                        method: 'POST',
                        target: '_blank',
                        params: {
                            access_token: Ext.Ajax.defaultHeaders.access_token
                        },
                        headers: {
                            'Authorization': Ext.Ajax.defaultHeaders.Authorization
                        },
                        standardSubmit: true
                    });
                }
            }
        }
		},
		initComponent: function() {
			var this$ = this;
			var store = this$.buildStore();
			Ext.apply(this$, {
				store: store,
				dockedItems: [{
					xtype: 'toolbar',
					dock: 'bottom',
					items: [{
						xtype: 'custompagingtoolbar',
						plugins: ['pagesize'],
						store: store,
						emptyMsg: getCommonTranslation('EMPTY_MESSAGE'),
						displayInfo: true
					}]
				}]
			});
			this$.addExportToolBarItems(this$,false);
			this$.callParent(arguments);
		},
		buildStore: function() {
			return Ext.create('Academia.store.program.programDetails.programBatches.courseParameter.StudentCourseReportByPeriodStore');
		}
});
