/**
 *  This form is used for student and faculty disciplinary action
 *  @author Sachin.Bangar
 */
Ext.define('Academia.view.personinfo.common.disciplinaryactivity.DisciplinaryActionForm', {
    //extend: 'Ext.form.Panel',
    extend:'Academia.view.common.CustomFieldForm',
    customFieldEntity:CONSTANTS.DISCIPLINARY_ACTION_CF_DATA,
    alias: 'widget.disciplinaryactionform',
    border : false,
    frame : false,
    plugins: "formlabelrequired",
    items: [{
        xtype: 'hidden',
        itemId: 'disciplinary_hidden_field',
        name: 'id'
    }, {
        xtype: 'hidden',
        name: 'version'
    },{

        xtype: 'fieldcontainer',
        layout: 'hbox',
        defaults: {
            labelAlign: 'top',
            width: 256
        },
        items: [{
        	xtype: 'customcombobox',
            fieldLabel: getPersonModuleTranslation('TYPE_OF_INCIDENT'),
            itemId: 'incidentType',
            name: 'incidentType',
            store:'personinfo.common.disciplinaryactivity.DisciplinaryTypeOfIncidentSearchCombo',
            allowBlank: false,
            //queryParam:'term',
            //triggerAction: 'all',
            forceSelection: true,
			displayField: 'value',
			valueField: 'id',
			editable: false
        }, {
            xtype: 'datefield',
            fieldLabel: getPersonModuleTranslation('DATE_OF_INCIDENT'),
            itemId: 'incidentDate',
            name: 'incidentDate',
          //--submitFormat: CONSTANTS.DATE_FORMAT,
            listeners: {
            	render: function(field) {
            		return dateFormatRender(field);
            	}
            },
            allowBlank: false,
            vtype : 'daterange',
            endDateField : 'dateOfAction',
            maxValue: new Date()
        }]
    
    }, {
        xtype: 'fieldcontainer',
        layout: 'vbox',
        defaults: {
            labelAlign: 'top',
            width: 256
        },
        items: [{
            xtype: 'customcombobox',
            fieldLabel: getPersonModuleTranslation('REPORTED_BY'),
            
            store: 'personinfo.common.disciplinaryactivity.ReportedByStore',
            valueField: 'name',
            displayField: 'value',
            value: 'USER',
            itemId: 'reportedByField',
            name: 'reportedBy',
            allowBlank: false,
            editable: false
        }]
    }, {

    	xtype: 'fieldcontainer',
        layout: 'hbox',
        defaults: {
            labelAlign: 'top',
            width: 256
        },
        items: [{
            xtype: 'customcombobox',
            fieldLabel: getPersonModuleTranslation('REPORTED_ID'),
            itemId: 'reportedByUserIdField',
            name: 'reportedByUser',
            store: 'coursetransaction.sectionmanagement.EmployeeIdValueSmartSearch',
            allowBlank: false,
            queryParam:'codeOrName',
            triggerAction: 'all',
            forceSelection: true,
            emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
            enableKeyEvents  : 'true',
            triggerCls : Ext.baseCSSPrefix + 'form-search-trigger',
			minChars:3,
			displayField: 'code', 
			valueField: 'id',
			/*displayTpl: new Ext.XTemplate(
             		'<tpl for="."between=" ">',
             		'{[typeof values === "string" ? values : values["code"]]}' +
             		'</tpl>'
            )*/
			listConfig: {
				listeners: {
					beforeshow: function(picker) {
						picker.minWidth = picker.up('combobox').getSize().width;
					}
				},
				loadingText: getCommonTranslation('SEARCHING'),
				emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
				getInnerTpl: function() {
					return '<div class="search-item">' +
					'{value}' +
					'</div>';
				}
			}
        },{
            xtype: 'textfield',
            fieldLabel: getPersonModuleTranslation('REPORTED_NAME'),            
            itemId: 'reportedByUserNameField',
            readOnly: true,
            name: 'reportedByUserName',
            allowBlank: false
        }]
    },{
        xtype: 'fieldcontainer',
        layout: 'hbox',
        defaults: {
            labelAlign: 'top',
            width: 256
        },
        items: [ {
            xtype: 'datefield',
            fieldLabel: getPersonModuleTranslation('DATE_OF_ACTION'),
          //--submitFormat: CONSTANTS.DATE_FORMAT,
            itemId: 'dateOfAction',
            name: 'dateOfAction',
            startDateField : 'incidentDate',
            listeners: {
            	  render: function(field) {
            		  return dateFormatRender(field);
            	  }
              },
            allowBlank: false,
            vtype : 'daterange',
            maxValue: new Date()
        }, {
            xtype: 'textfield',
            fieldLabel: getPersonModuleTranslation('ACTION_TAKEN'),
            itemId: 'actionTaken',
            name: 'actionTaken',
            allowBlank: false
        }]
    }, {
    	xtype: 'fieldcontainer',
        layout: 'vbox',
        defaults: {
            labelAlign: 'top',
            width: 536
        },
        items: [{
            xtype: 'textareafield',
            fieldLabel: getPersonModuleTranslation('INCIDENT_DETAILS'),
            name: 'details',
            maxLength:1000
        }, {
            xtype: 'textareafield',
            fieldLabel: getPersonModuleTranslation('REMARK'),
            name: 'remarks',
            maxLength:255
        }]
    },{
		xtype: 'fieldcontainer',    
		layout : {
			type : 'vbox'
		},
		cls:'horizontal-scrolling-fix',
		defaults : {
			width: 536,
			labelAlign : 'top'
		},
		items : [{
			xtype:'disciplinaryactiondocumentgrid',
			itemId:'disciplinaryactiondocumentgrid',
			hidden:true,
			style:{
				marginLeft:'0px',
			},
			flex:.1
		}]
	
	},{ 
		xtype:'fieldcontainer',
    	width:'auto',
		layout : 'hbox',
		items: [{
            xtype: 'button',
            text: getCommonTranslation('SUBMIT'),
            itemId: 'submitButtonId',
            buttonAlign: 'right',
            ui: 'CustomBtnSubmit',
            scale: CONSTANTS.BUTTONSIZE,
            formBind: true
        }, {
            xtype: 'button',
            text: getCommonTranslation('CANCEL'),
            ui: 'CustomBtnCancel',
            itemId: 'cancelButtonId',
            scale: CONSTANTS.BUTTONSIZE

        },
        {
			 xtype: 'button',
			 //width: 536,
			 name: 'courseSyllabus',
			 text:getCommonTranslation('UPLOAD_DOC'),
			 itemId: 'uploadDisciplinaryItemId',
			 ui: 'CustomBtnThird',
		   	 scale : CONSTANTS.BUTTONSIZE
		}]
    }]
});
