/**
 * @author Pravin.Surve
 */
Ext.define('Academia.view.personinfo.common.feedback.ActiveSurveyForm', {
    extend: 'Ext.form.Panel',
    alias: 'widget.activesurveyform',
    border : false,
    frame : false,
    plugins: "formlabelrequired",
    items: [{
        xtype: 'hidden',
        itemId: 'activesurvey_hidden_field',
        name: 'id'
    }, {
        xtype: 'fieldcontainer',
        layout: 'hbox',
        defaults: {
            labelAlign: 'top',
            width: 256
        },
            items: [{
            	xtype: 'textfield',
                fieldLabel: getPersonModuleTranslation('SURVEY_NAME'),
                
                name: 'surveyName'
            }, {
            	xtype: 'textfield',
                name: 'program',
                fieldLabel: getPersonModuleTranslation('PROGRAM'),
                emptyText: getPersonModuleTranslation('PROGRAM')
            }]
        }, {
            xtype: 'fieldcontainer',
            layout: 'hbox',
            defaults: {
                labelAlign: 'top',
                width: 256
            },
            items: [{
            	xtype: 'textfield',
                name: 'batch',
                fieldLabel: getPersonModuleTranslation('BATCH'),
                emptyText: getPersonModuleTranslation('BATCH')
            },{
            	xtype: 'textfield',
                fieldLabel: getPersonModuleTranslation('PERIOD'),
                
                name: 'period'
            }]
        }, {
            xtype: 'fieldcontainer',
            layout: 'hbox',
            defaults: {
                labelAlign: 'top',
                width: 256
            },
            items: [{
            	xtype: 'textfield',
                name: 'SECTION',
                fieldLabel: getPersonModuleTranslation('SECTION'),
                emptyText: getPersonModuleTranslation('SECTION')
            },{
            	xtype: 'textfield',
                name: 'course',
                fieldLabel: getPersonModuleTranslation('COURSE'),
                emptyText: getPersonModuleTranslation('COURSE')
            }]
        }, {
            xtype: 'fieldcontainer',
            layout: 'hbox',
            defaults: {
                labelAlign: 'top',
                width: 256
            },
            items: [{
            	xtype: 'textfield',
	            name: 'courseComponent',
	            fieldLabel: getPersonModuleTranslation('COURSE_COMPONENT'),
	            emptyText: getPersonModuleTranslation('COURSE_COMPONENT')
            },{
            	xtype: 'textfield',
                name: 'filledBy',
                fieldLabel: getPersonModuleTranslation('FILLED_BY'),
                emptyText: getPersonModuleTranslation('FILLED_BY')
	    	}]
          },{
              xtype: 'fieldcontainer',
              layout: 'hbox',
              defaults: {
                  labelAlign: 'top',
                  width: 256
              },
              items: [{
	        	xtype: 'textfield',
	            name: 'numberOfRespondentsInvited',
	            fieldLabel: getPersonModuleTranslation('NUMBER_OF_RESPONDENTS_INVITED'),
	            emptyText: getPersonModuleTranslation('NUMBER_OF_RESPONDENTS_INVITED')
	    	},{
            	xtype: 'textfield',
                fieldLabel: getPersonModuleTranslation('NUMBER_OF_RESPONSES_RECEIVED'),
                
                name: 'numberOfResponsesReceived'
        	}]
          },{
              xtype: 'fieldcontainer',
              layout: 'hbox',
              defaults: {
                  labelAlign: 'top',
                  width: 256
              },
              items: [{
        		xtype: 'textfield',
                fieldLabel: getPersonModuleTranslation('STATUS'),
                
                name: 'status'
		    }]
          },   {
            xtype: 'fieldcontainer',
            width: '100%',
            
            items: [{
                xtype: 'button',
                text: getCommonTranslation('SUBMIT'),
                itemId: 'submitButtonId',
                buttonAlign: 'right',
                ui: 'CustomBtnSubmit',
                scale: CONSTANTS.BUTTONSIZE,
                formBind: true
            }, {
                xtype: 'button',
                text: getCommonTranslation('CANCEL'),
                ui: 'CustomBtnCancel',
                itemId: 'cancelButtonId',
                scale: CONSTANTS.BUTTONSIZE

            }]
        }]
});