/**
 * This form is used for the student & faculty feedback receive form.
 * @author Sachin.Bangar
 */
Ext.define('Academia.view.personinfo.common.feedback.FeedbackReceiveForm', {
    extend: 'Ext.form.Panel',
    alias: 'widget.feedbackreceiveform',
    border: false,
    frame: false,
    plugins: "formlabelrequired",
    items: [{
        xtype: 'hidden',
        itemId: 'feedback_hidden_field',
        name: 'id'
    }, {
        xtype: 'hidden',
        name: 'version'
    }, {
        xtype: 'fieldcontainer',
        layout: 'hbox',
        defaults: {
            labelAlign: 'top',
            width: 256
        },
        items: [{
            xtype: 'textfield',
            fieldLabel: getPersonModuleTranslation('QUESTIONNAIRE_NUMBER'),
            
            name: 'questionnaireNumber'
        }]
    }, {
        xtype: 'fieldcontainer',
        layout: 'hbox',
        defaults: {
            labelAlign: 'top',
            width: 256
        },
        items: [{
            xtype: 'textfield',
            fieldLabel: getPersonModuleTranslation('COURSE_NAME'),
            
            name: 'courseName'
        }, {
            xtype: 'textfield',
            fieldLabel: getPersonModuleTranslation('FEEDBACK_GIVEN_BY'),
            
            name: 'feedbackGivenBy'
        }]
    }, {
        xtype: 'fieldcontainer',
        layout: 'hbox',
        defaults: {
            labelAlign: 'top',
            width: 256
        },
        items: [{
            xtype: 'datefield',
            fieldLabel: getPersonModuleTranslation('COMPLETION_DATE'),
            itemId: 'DurationId',
            name: 'completionDate',
			listeners: {
				render: function(field) {
					return dateFormatRender(field);
				}
			}
        }, {
            xtype: 'textfield',
            fieldLabel: getPersonModuleTranslation('STATUS'),
            
            name: 'status'
        }]
    }, {
        xtype: 'fieldcontainer',
        width: '100%',
        
        items: [{
            xtype: 'button',
            text: getCommonTranslation('SUBMIT'),
            itemId: 'submitButtonId',
            buttonAlign: 'right',
            ui: 'CustomBtnSubmit',
            scale: CONSTANTS.BUTTONSIZE,
            formBind: true
        }, {
            xtype: 'button',
            text: getCommonTranslation('CANCEL'),
            ui: 'CustomBtnCancel',
            itemId: 'cancelButtonId',
            scale: CONSTANTS.BUTTONSIZE

        }]
    }]
});
