/**
 * KYS Details Grid 
 */
Ext.define('Academia.view.personinfo.common.kys.KYSDetailsGrid', {
    //extend: 'Ext.grid.Panel',
	extend: 'Academia.view.facilitiesresources.resourcebooking.StaticGridExcelExport',
    alias: 'widget.kysdetailsgrid',
    title: getPersonModuleTranslation('KYS_DETAILS'),
    border: true,
    autoScroll: true,
    viewConfig: {
        stripeRows: true
    },	
    tbar: [ {
        xtype: 'button',
        itemId: 'btnSubmit',
        tooltip : getCommonTranslation('SUBMIT'),
        text:getCommonTranslation('SUBMITKYS')
    },  {
        xtype: 'button',
        itemId: 'btnView',
        tooltip: getCommonTranslation('VIEW'),
        iconCls: 'view-icon'
    }],

    columns: [{
        header: getPersonModuleTranslation('SUBMISSION_DATE'),
        dataIndex: 'submissionDate',
        sortable: true,
        flex: .2,
		renderer:function(date) {
			return dateRender(date);
		}
    }, {
        header: getPersonModuleTranslation('NO_OF_DAYS_OVERDUE'),
        dataIndex: 'daysOverdue',
        sortable: true,
        flex: .2
    }, {
        header: getPersonModuleTranslation('LAST_DATE_OF_SUBMISSION'),
        dataIndex: 'lastSubmissionDate',
        sortable: true,
        flex: .2
    }, {
        header: getPersonModuleTranslation('STATUS'),
        dataIndex: 'status',
        sortable: true,
        flex: .2,
        renderer: function(value) {
        	var msg = "";
            if(value === 'SUBMITTED'){
            	msg =  getPersonModuleTranslation('SUBMITTED');
            }else if(value == 'OVERDUE_SUBMISSION'){
            	msg = getPersonModuleTranslation('OVERDUE_SUBMISSION');
            }else if(value == 'PENDING'){
            	msg = getPersonModuleTranslation('PENDING');
            }else{
            	msg =  getPersonModuleTranslation('LATE_SUBMITTED');
            }
            
            return msg;
        }
    }],
    initComponent: function() {
        var this$ = this;
        var store = this$.buildStore();
        Ext.apply(this$, {
            store: store,
            dockedItems: [{
                xtype: 'toolbar',
                dock: 'bottom',
                items: [{
                    xtype: 'custompagingtoolbar',
                    plugins: ['pagesize'],
                    store: store,
                    emptyMsg: getCommonTranslation('EMPTY_MESSAGE'),
                    displayInfo: true
                }]
            }]
        });
        this$.addExportToolBarItems(this$);
        this$.callParent(arguments);
    },
    buildStore: function() {
        return Ext.create('Academia.store.personinfo.common.kys.KYSDetailsStore');
    }

});
