/**
 * Swapnil.patil
 */

Ext.define('Academia.view.personinfo.common.pasthistory.ChurchEmploymentHistoryWindow', {
	extend: 'Ext.window.Window',
	alias: 'widget.churchemploymenthistorywindow',
	modal: true,
	autoScroll:true,
	title: getPersonModuleTranslation('CHURCH_EMPLOYMENT_HISTORY'),
	frame: true,
	autoScroll:false,
	id:'churchemploymenthistorywindowItemId',
	maxHeight:500,
	width: '50%',
	height:'55%',
	padding:'10 10 10 10',
	items: [{
		xtype: 'fieldcontainer',
		width:'100%',
		layout: {
			type: 'hbox'
		},
		defaults :{
			labelAlign:'top'
		},
		items: [{
			xtype: 'displayfield',
			fieldLabel: getPersonModuleTranslation('CHURCH_AFFILIATION'),
			name: 'churchAffiliationWin',
			style:{marginLeft:'13px'},
			itemId :'churchAffiliationItemIdWin'

		},{
			xtype: 'displayfield',
			fieldLabel: getPersonModuleTranslation('NAME_OF_LOCAL_CHURCH_PARISH'),
			name: 'localChurchNameWin',
			itemId: 'localChurchNameItemIdWin', 
			style:{marginLeft:'53px'},
		}]
	},{
		xtype: 'fieldcontainer',
		items: [{
			xtype: 'grid',
			name:'employeHistoryGrid',
			itemId:'employeHistoryGridItemId',
			border:true,
			//modal : true,
			//resizable:true,
			autoScroll: true,	
			frame:false,
			//selType:'checkboxmodel',
    	    maxHeight: 200,
			/*style:{marginLeft:'10px'
			},*/
			viewConfig: {
				stripeRows: CONSTANTS.STRIPEROWS
			},
			store: 'personinfo.common.pasthistory.ChurchInformationStore',
			/*maxHeight:300,
			hideHeaders :false,
			selModel: {
				checkOnly : true, 
				allowDeselect: false
			},*/
			columns: [{
				header: getPersonModuleTranslation('POSITION'),
				dataIndex: 'position',
				sortable:false,
				flex: .2,
			}, {
				header: getPersonModuleTranslation('COUNTRY'),
				dataIndex: 'country',
				sortable:false,
				//sortable: true,
				flex: .1,
				renderer:function(value){
					if(!isNullOrEmpty(value))
						return value.countryName;
					else 
						return null;

				}
			}, {
				header: getCommonTranslation('FROM_DATE'),
				dataIndex: 'fromDate',
				sortable:false,
				flex: .2,
				renderer:function(record){
					return dateRender(record);
				}

			},{
				header:  getCommonTranslation('TO_DATE'),
				dataIndex: 'toDate',
				flex:.2,
				sortable:false,
				renderer:function(record){
					return dateRender(record);
				}
			}]
		}]
	}]

});