/**
 * @author swapnil patil church information Form
 */
Ext.define('Academia.view.personinfo.common.pasthistory.ChurchInformationForm', {
	extend:'Academia.view.common.IdGeneratorCustomForm',
    alias: 'widget.churchinformationform',
	customFieldEntity:CONSTANTS.CHURCH_INFORMATION_CD,
    border : false,
    frame : false,
    plugins: "formlabelrequired",
    style:{margin:'25px 23px 41px'},
    width:900,
    listeners:{
    	labelAlign: 'top',
    },
    items: [{
        xtype: 'hidden',
        itemId: 'churchInfo_hidden_field',
        name: 'id'
    },{
        xtype: 'fieldcontainer',
        layout: 'hbox',
        defaults: {
            labelAlign: 'top',
            width: 256
        },
     items: [{
         xtype: 'textfield',
         fieldLabel: getPersonModuleTranslation('WHAT_IS_YOUR_CHURCH_AFFILIATION'),
         name: 'churchAffiliation',
         allowBlank: false,
         maxLength:255,
         itemId :'churchAffiliationItemId'
        },{
		  xtype: 'textfield',
		  fieldLabel: getPersonModuleTranslation('NAME_OF_LOCAL_CHURCH_PARISH'),
		  name: 'localChurchName',
		  itemId: 'localChurchNameItemId',
		  maxLength:150,
		  allowBlank: false,
		}]
     },{
        xtype: 'fieldcontainer',
        layout: 'hbox',
        defaults: {
            labelAlign: 'top',
            width:462
        },
        items:[{
            xtype: 'multiselectcombofield2',
            fieldLabel: getPersonModuleTranslation('MEMBERSHIP_STATUS'),            
            name: 'membershipStatus',
            itemId:'membershipStatus',
            valueField: 'id',
            displayField: 'value',
            store: 'common.MembershipStatusStore',
            //editable: false,
            matchFieldWidth:true
        }]
     }, {
    	 xtype : 'fieldcontainer',
    	 itemId:'employementFieldLabelItemId',
//    	 width : '100%',
    	 layout : {
    		 type : 'hbox'
    	 },
    	 style:{
    		 marginTop:'18px',
    		 marginBottom:'15px'
    	 },
    	 defaults : {
    		 labelAlign : 'top'
    	 },
    	 items : [ {
    		 html: '<b><u>Church Employment History:</u></b>',
    		 margin: 0,
    	 }]

     }, {
			xtype: 'fieldcontainer',
			layout: {
				type: 'hbox'
			},
			items : [{
				xtype: 'fieldcontainer',
				itemId:'employmentHistoryContainerId',
				items:[{
					xtype : 'fieldcontainer',
//					width: '100%',
					itemId:'employmentHistoryContainer',
					layout : 'hbox',
					defaults: {
						labelAlign: 'top',
						width: 150
					},
					items : [{
				        xtype: 'hidden',
				        itemId: 'churchEmploymenthistory_hidden_field',
				        name: 'historyId',
				        itemId:'historyId'
				    },{
						 xtype: 'textfield',
						 name: 'position',
						 itemId:'position',
						 maxLength:50,
						 fieldLabel: getPersonModuleTranslation('POSITION'),     
						 allowBlank: true
					 },  
					 {
						 xtype: 'customcombobox',
						 fieldLabel: getPersonModuleTranslation('COUNTRY'),
						 store: 'common.CountryStore',
						 itemId: 'countryCombo',
						 valueField: 'id',
						 displayField: 'countryName',
						 name: 'country',
//						 queryMode: 'remote',
						 editable: false,
					 },{
						 xtype: 'datefield',
						 name: 'fromDate',
						 itemId: 'fromDate',
						 fieldLabel: getCommonTranslation('FROM_DATE'), //Birth Date
						 editable: true,
						 maxValue: new Date(),
						 vtype: 'daterange',
						 endDateField: 'toDate',
						//--submitFormat: CONSTANTS.DATE_FORMAT,
//						 format: CONSTANTS.DATE_FORMAT,
						 listeners: {
							 render: function(field) {
								 return dateFormatRender(field);
							 }
						 }
					 },{
						 xtype: 'datefield',
						 name: 'toDate',
						 itemId: 'toDate',
						 fieldLabel: getCommonTranslation('TO_DATE'), //Birth Date
						 editable: true,
						 maxValue: new Date(),
						 vtype: 'daterange',
						 startDateField: 'fromDate',
						//--submitFormat: CONSTANTS.DATE_FORMAT,
//						 format: CONSTANTS.DATE_FORMAT,
						 listeners: {
							 render: function(field) {
								 return dateFormatRender(field);
							 }
						 }
					 },{
						xtype: 'button',
						itemId: 'btnAddEmploymentHistory',
						cls: 'CustomBodyBtnSettings',
						text: getCommonTranslation('ADDBUTTONTEXT'),	
						tooltip: getCommonTranslation('ADD'),
						style:{
							marginTop:'22px'
						}
					}]
				}]
			}]
		}, {
        xtype: 'fieldcontainer',
        width: '100%',        
        items: [{
            xtype: 'button',
            text: getCommonTranslation('SUBMIT'),
            itemId: 'submitButtonId',
            buttonAlign: 'right',
            ui: 'CustomBtnSubmit',
            scale: CONSTANTS.BUTTONSIZE,
            formBind: true
        }, {
            xtype: 'button',
            text: getCommonTranslation('CANCEL'),
            ui: 'CustomBtnCancel',
            itemId: 'cancelButtonId',
            scale: CONSTANTS.BUTTONSIZE

        }]
    }]
});
