/**
 * @author dharmendra.prajapati
 * 
 */
Ext.define('Academia.view.personinfo.common.pasthistory.CompetitiveExamForm', {
	//extend:'Academia.view.common.DynamicFieldForm',
	extend:'Academia.view.common.IdGeneratorCustomForm',
    alias: 'widget.competitiveexamform',
    border : false,
    frame : false,
    plugins: "formlabelrequired",
    /*listeners:{
		   	beforeRender: function(){
			    Ext.apply(this,{ 
				   	customFieldEntity:CONSTANTS.COMPETITIVE_EXAM_DETAIL,
				    columns: 1
			    });
		   	}
    },*/
    initComponent: function() {
	    Ext.apply(this,{ 
		   	customFieldEntity:CONSTANTS.COMPETITIVE_EXAM_DETAIL,
		    columns: 2
	    });
	    
	    this.callParent(arguments);
},
    items: [{
        xtype: 'hidden',
        itemId: 'competitive_hidden_field',
        name: 'id'
    }, {
        xtype: 'hidden',
        name: 'version'
    },{
        xtype: 'hidden',
        itemId:'filePath',
        name: 'filePath'
    },{
		xtype : 'hidden',
		name : 'module'
	}, {
		xtype : 'hidden',
		name : 'entityId'
	}, {
		xtype : 'hidden',
		name : 'entityType'
	}, {
        xtype: 'fieldcontainer',
        width: 'auto',
        defaults: {
            labelAlign: 'top',
            width: 256
        },
        layout: {
            type: 'hbox'
        },
        items: [{
            xtype: 'nestedJsonCombo',
            fieldLabel: getPersonModuleTranslation('NAME_OF_EXAM'),
            store: 'admission.applications.history.ExaminationName',
            valueField: 'id',
            displayField: 'value',
            name: 'examinationName',
            itemId: 'examinationName',
            allowBlank:false,
            editable: false,
            hideTrigger:false,
            triggerAction: 'all',
            forceSelection:true
        }, {
            xtype: 'textfield',
            fieldLabel: getPersonModuleTranslation('REGISTRATION_ENROLMENT_NO'),
            name: 'enrollmentNumber',
            allowBlank:false,
            itemId : 'medicalConditionId',
            maxLength: 100
        },{
        	xtype: 'datefield',
        	name: 'yearOfExam',
        	itemId:'yearOfExam',
        	listeners: {
        		render: function(field) {
        			return dateFormatRender(field);
        		}
        	},
        	vtype: 'daterange',
        	editable:false,
        	fieldLabel: getCommonTranslation('DATE_OF_EXAM'),
        	maxValue:new Date(),
        }]
    }, {
        xtype: 'fieldcontainer',
        width: 'auto',
        defaults: {
            labelAlign: 'top',
            width: 256
        },
        layout: {
            type: 'hbox'
        },
        items: [{
            xtype: 'customcombobox',
            fieldLabel: getCommonTranslation('MONTH_OF_EXAM'),
            name: 'monthOfExamination',
            itemId: 'monthItemId',
            editable: false,
            store: Ext.create('Academia.store.personinfo.common.pasthistory.ApplicantEducationMonthStore'),
            displayField: 'value',
            valueField: 'code',
            queryMode: 'local',
            labelAlign: 'top',
            width: 256
    },{
        xtype: 'customcombobox',
        fieldLabel: getCommonTranslation('YEAR_OF_EXAM'),
        name: 'yearOfExamination',
        itemId: 'yearItemId',
        editable: false,
        store: Ext.create('Academia.store.personinfo.common.pasthistory.ApplicantEducationYearStore'),
        displayField: 'value',
        valueField: 'id',
        queryMode: 'local',
        labelAlign: 'top',
        width: 256
    }]
    }, {
        xtype: 'fieldcontainer',
        width: 'auto',
        defaults: {
            labelAlign: 'top',
            width: 256
        },
        layout: {
            type: 'hbox'
        },
        items: [{
            xtype: 'textfield',
            fieldLabel: getPersonModuleTranslation('SCORE'),
            name: 'score',
            maxLength: 100,
            itemId : 'score'
        }, {
            xtype: 'textfield',
            fieldLabel: getPersonModuleTranslation('PERCENTILE'),
            name: 'percentile',
            maxLength: 100,
            itemId : 'percentile'
        }]
    }, {
        xtype: 'fieldcontainer',
        width: 'auto',
        layout: 'hbox',
        defaults: {
            labelAlign: 'top',
            width: 256
        },
        items: [{
            xtype: 'textfield',
            fieldLabel: getPersonModuleTranslation('RANK_1'),
            name: 'rankOne',
            maxLength: 100,
            itemId : 'rankOne'
        }, {
            xtype: 'textfield',
            fieldLabel: getPersonModuleTranslation('RANK_2'),
            name: 'rankTwo',
            maxLength: 100,
            itemId : 'rankTwo'
        }]
    },{
    	xtype: 'fieldcontainer',
        width: 'auto',
        layout: 'hbox',
        defaults: {
            labelAlign: 'top',
            width: 256
        },
        items: [{
        	xtype: 'nestedJsonCombo',
			name: 'officerFormativeQualified',
			itemId:'officerFormativeQualified',
			store:'admission.applications.history.OfficerFormativeQualifiedStore',
			fieldLabel: getPersonModuleTranslation('OFFICER_FORMATIVE_QUALIFIED'),
			valueField: 'id',
			displayField: 'value',
			editable: false,
            disableKeyFilter: false,
			forceSelection:true 
        },{
        	xtype: 'datefield',
        	name: 'completionDate',
        	itemId:'completionDate',
        	listeners: {
        		render: function(field) {
        			return dateFormatRender(field);
        		}
        	},
        	vtype: 'daterange',
        	editable:false,
        	fieldLabel: getPersonModuleTranslation('COMPLETION_DATE'),
        	hidden:true
        }]
    },{
        xtype: 'fieldcontainer',
        defaults: {
            labelAlign: 'top',
            layout: 'vbox',
            width: 536
        },
        items: [{
            xtype: 'textfield',
            fieldLabel: getPersonModuleTranslation('SUBJECT_SPECIALIZATION_IF_ANY'),
            name: 'specialization',
            maxLength: 200,
            itemId : 'specialization'
        }/*,
        {
            xtype: 'filefield',
            fieldLabel: getCommonTranslation('UPLOAD_FILE'),
			buttonText: getCommonTranslation('UPLOAD'),
            itemId: 'uploadFileItemId',
            ui: 'CustomBtnSubmit',
            name: 'file',
            width: 256,
            labelAlign: 'top',
            allowBlank:true,
            listeners: {
                specialkey: function(me, e) {
                    if (e.getKey() == e.TAB) {
                        e.stopEvent();
                    }
                }
            }
        },{
			xtype: 'displayfield',
			itemId: 'competitiveDownloadURL',
			hidden:true,
			style:{'margin-left':'10px'},
			name:'filePath',
			renderer:function(value,meta,record){
				if(value==0){
					return value;
				}
				else {
					return '<a href=#>'+value+'</a>'
				}
			},
			listeners: {
				afterrender: function(c){
	    			c.getEl().on('click', function(){
	    				var path = this.up('competitiveexamform').down('#competitiveDownloadURL').getValue()
	    	       		var csvForm = Ext.create('Ext.form.Panel'); 
	    				csvForm.getForm().submit({
							   target: '_blank',
							   method:'POST',
							   params :{
								   access_token : Ext.Ajax.defaultHeaders.access_token,
								   path: path
							   },
							   headers :{'Authorization':Ext.Ajax.defaultHeaders.Authorization},
							   url: SERVERURL.PATH_FILE_DOWNLOAD_TEMP_API ,
							   standardSubmit :true
						   });
	    			}, c);
	    		}
	    	}
			}*/]
    
    },{
    	 xtype: 'fieldcontainer',
         width: 'auto',
         defaults: {
             labelAlign: 'top',
             width: 256
         },
         layout: {
             type: 'hbox'
         },
        items: [{
            xtype: 'filefield',
            fieldLabel: getCommonTranslation('UPLOAD_FILE'),
			buttonText: getCommonTranslation('UPLOAD'),
            itemId: 'uploadFileItemId',
            ui: 'CustomBtnSubmit',
            name: 'file',
            width: 256,
            labelAlign: 'top',
            allowBlank:true,
            listeners: {
                specialkey: function(me, e) {
                    if (e.getKey() == e.TAB) {
                        e.stopEvent();
                    }
                }
            }
        },{
        	xtype:'button',
			text:getCommonTranslation('REMOVE'),
			itemId: 'removeButtonId',
		    ui: 'CustomBtnSubmit',
		    style: {
				marginTop: '31px'
			}
        }]
    },{
   	 xtype: 'fieldcontainer',
        width: 'auto',
        defaults: {
            labelAlign: 'top',
            width: 536,
        },
        layout: {
            type: 'hbox'
        },
       items: [{
			xtype: 'displayfield',
			itemId: 'competitiveDownloadURL',
			hidden:true,
			name:'filePath',
			
			renderer:function(value,meta,record){
				if(value==0){
					return value;
				}
				else {
					return '<a href=#>'+value+'</a>'
				}
			},
			listeners: {
				afterrender: function(c){
	    			c.getEl().on('click', function(e){
	    				if(e.target.tagName=='A') {
	    				var competitiveDownloadURLField =  this.up('competitiveexamform').down('#competitiveDownloadURL');
	    				var path = competitiveDownloadURLField.getValue();
	    				if(!isNullOrEmpty(path) && !competitiveDownloadURLField.isDisabled()) {
	    	       		var csvForm = Ext.create('Ext.form.Panel'); 
	    				csvForm.getForm().submit({
							   target: '_blank',
							   method:'POST',
							   params :{
								   access_token : Ext.Ajax.defaultHeaders.access_token,
								   path: path
							   },
							   headers :{'Authorization':Ext.Ajax.defaultHeaders.Authorization},
							   url: SERVERURL.PATH_FILE_DOWNLOAD_TEMP_API ,
							   standardSubmit :true
						   });
						}
	    				}
	    			}, c);
	    		}
	    	}
			}]
    
    },{
        xtype: 'fieldcontainer',
        defaults: {
            labelAlign: 'top',
            width: 536
        },
        items: [{
            xtype: 'textarea',
            fieldLabel: getPersonModuleTranslation('REMARKS'),
            name: 'remarks',
            itemId : 'remarks',
            maxLength: 2000
        }]
    
    }, {
        xtype: 'fieldcontainer',
        width: '100%',
        
        items: [{
            xtype: 'button',
            text: getCommonTranslation('SUBMIT'),
            itemId: 'submitButtonId',
            buttonAlign: 'right',
            ui: 'CustomBtnSubmit',
            scale: CONSTANTS.BUTTONSIZE,
            formBind: true
        }, {
            xtype: 'button',
            text: getCommonTranslation('CANCEL'),
            ui: 'CustomBtnCancel',
            itemId: 'cancelButtonId',
            scale: CONSTANTS.BUTTONSIZE

        }]
    }]
});